/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.company;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyTechnologyProcess;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 11:51
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ICompanyTechnologyProcessService extends IBaseService<CompanyTechnologyProcess>{


	/**
	 * 工艺流程的分页信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月31日-上午10:40:34
	 * @param cid 企业ID
	 * @param param 查询参数
	 * @return
	 */
	PageInfo<CompanyTechnologyProcess> getTechnologyProcessPageInfo(Long cid,JqGridParam param);
	
	/**
	 * 根据企业ID，获取工艺流程列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月1日-上午11:47:30
	 * @param cid
	 * @return
	 */
	List<CompanyTechnologyProcess> getTechnologyProcessListByCid(Long cid,boolean isNeedFilesData);
	
	/**
	 * 根据企业ID，获取指定时间的工艺流程列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月15日-上午8:42:31
	 * @param cid 企业ID
	 * @param isNeedFilesData 是否需要文件数据
	 * @param year 年份
	 * @return
	 */
	List<CompanyTechnologyProcess> getTechnologyProcessListByCid(Long cid,boolean isNeedFilesData,int year);
}
