/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.company;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 *
 * 《xxxService》
 *
 *
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 11:51
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ICompanyOrganizationService extends IBaseService<CompanyOrganization>{

	/**
	 *
	 *
	 * @Comments:  根据企业ID，获取组织架构列表信息
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年6月20日-上午10:03:59
	 * @param cid
	 * @return
	 */

	List<CompanyOrganization> getListByCid(Long cid);

	/**
	 * 根据cid和机构id查询机构信息
	 * @param cid
	 * @param orgId
	 * @return
	 */
	List<CompanyOrganization> getListByCidAndOrgId(Long cid, Long orgId);

	/**
	 *
	 *
	 * @Comments:  根据组织架构名称，全匹配查找组织架构列表
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月3日-下午2:26:20
	 * @param organizationName 组织架构名称
	 * @param cid 企业ID
	 * @return
	 */
	List<CompanyOrganization> getListByName(String organizationName,Long cid);
    List<CompanyOrganization> getListByNameList(List<String> orgNameList, Long cid);


	/**
	 * 跟新组织机构的树节点路径
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月5日-下午4:09:46
	 * @param pid 新的父节点ID 如果为顶级节点，则为cid
	 * @param id 节点ID
	 * @param staffId 登录用户ID
	 * @return
	 */
	CompanyOrganization updateOrganizationTreePath(Long newPid,Long id,Long staffId);

	/**
	 * 根据cid删除组织架构
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月24日-下午4:19:04
	 * @param cid
	 * @param staffid
	 */
	void deleteOrgByCid(Long cid, Long staffid);

	/**
	 *
	 * 获取组织机构数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月13日-下午3:41:58
	 * @param cid
	 * @return
	 */
	int getCountByCid(Long cid);

	List<CompanyOrganization>  getAllChildrenCompanyOrganizationsByPid(Long pid,Long cid);

	/**
	 * @param id
	 * @return 返回组织架构名称信息包含删除情况；
	 */
	String getOrgNameById(Long id);

	/**
	 * @param orgId
	 * @param year
	 * @return 获取组织机构历史名称
	 */
	String getHistoryOrgNameByOrgIdAndYear(Long orgId, Date year);

	CompanyOrganization addCompanyOrganization(CompanyOrganization org);

	/**
	 *
	 * @Comments:  <根据父的组织id，获取子节点>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年11月20日-上午10:17:41
	 * @param cid
	 * @param orgPid
	 * @return
	 */
	List<CompanyOrganization> getChildrenListByCidAndOrgPid(Long cid, String orgPid,String orgName,Long loginStaffId);


	CompanyOrganization getCompanyOrganizationByNameAndLevel(String organizationName,Byte level,Long cid);


	 /**
	  * @Comments:  <根据组织名以及树路径获取对象>
	  * @author zhoulj(周利军) [1217102780@qq.com]
	  * @since 2020/2/27-17:19
	  * @param organizationName
	  * @param treePath
	  * @param cid
	  * @return cn.smarthse.modules.health.entity.base.company.CompanyOrganization
	 */
	public CompanyOrganization getCompanyOrganizationByNameAndTreePath(String organizationName, String treePath, Long cid);

	 /**
	 *
	 * @Comments:  <根据父的组织id，获取子节点>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年11月20日-上午10:17:41
	 * @param cid
	 * @param orgPid
	 * @return
	 */
	List<CompanyOrganization> getChildrenOrgListByCidAndOrgPid(Long cid, Long orgPid,Long loginStaffId);


	/**
	 *
	 * @Comments:  <获取excel数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年12月17日-上午11:46:13
	 * @param ossfile
	 * @param cid
	 * @param loginStaffId
	 * @return
	 */
	void getCompanyOrganizationDataFromExcel(String ossfile, Long cid, Long loginStaffId);

	void updateOrgSubmit(CompanyOrganization organization, Long loginStaffId);


	/**
	 *
	 * @Comments:  <调整排列顺序>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年12月23日-下午3:44:18
	 */
	void  updateChildenOrderSubmit(String ids, Long loginStaffId);

	Boolean isExistOrgName(CompanyOrganization entity);


	/**
	 *
	 * @Comments:  <获取数据权限>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年12月30日-上午11:49:02
	 * @return
	 */
	Byte getDataPerByLoginStaffId(String permissionCode, String loginStaffId);

	CompanyOrganization companyOrganizationService(Long cid, String code);

	CompanyOrganization addCompanyOrganizationByCode(Long cid, String name, String code);

	List<CompanyOrganization> getAllCompanyOrganizations(Long cid);



	/**
	 * 获取部门人员数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年6月9日-上午9:31:41
	 * @param cid
	 * @return
	 */
	Map<Long,Integer> getAllDeptStaffNum(Long cid);


	/**
	 * 获取有子部门的部门id
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年6月30日-上午10:38:37
	 * @param cid
	 * @return
	 */
	Map<Long,Long> getAllPidDept(Long cid);


	int addOrgList(List<CompanyOrganization> orgList);

     List<CompanyOrganization> getAllCompanyOrganizationsHasCode(Long cid);


     void upateCompanyOrganizationIncludeNull(CompanyOrganization co);

     List<CompanyOrganization> getListByCidHuadong(Long cid);

     Map<String, CompanyOrganization> getAllCompanyOrganizationByCids(Set<Long> cidSet);


	/**
	 * 获取部门及接害人员信息
	 *
	 * @param trainId
	 * @param orgId
	 * @param staffName
	 * @param cid
	 * @param sortBy
	 * @return
	 */
	List<CompanyOrganization> getOrgAndStaffList(Long trainId, Long orgId, String staffName, Long cid, Byte sortBy);

    /**
     * 根据cid获取部门信息
     * @param cid
     * @return
     */
    List<CompanyOrganization> getByCid(Long cid);

    /**
     * 劳动者培训 条件框搜索人员信息
     *
     * @param trainId
     * @param orgId
     * @param staffName
     * @param cid
     * @param sortBy
     * @return
     */
    List<StaffWorkRole> getStaffBySearch(Long trainId, Long orgId, String staffName, Long cid, Byte sortBy);
}
