/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.company;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.vo.base.company.CompanyFunOrgVo;

import java.util.List;


 /**
 *
 * 《xxxService》
 *
 *
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 11:51
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ICompanyFunctionalOrganizationService extends IBaseService<CompanyFunctionalOrganization>{


	/**
	 * 根据企业ID，获取职能机构列表
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年6月28日-下午1:35:21
	 * @param cid
	 * @return
	 */
	List<CompanyFunctionalOrganization> getListByCid(Long cid);

	/**
	 * 保存只能机构信息
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月25日-下午4:44:24
	 * @param entity
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	public CompanyFunctionalOrganization save(CompanyFunctionalOrganization entity, Long loginStaffId, Long cid);

	/**
	 * 添加企业的默认只能机构。
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2019年5月17日-下午4:10:36
	 * @param cid 企业ID
	 * @param hseDirectorName 职业卫生负责人
	 * @param hseDirectorTel 职业卫生负责人姓名
	 */
	public List<CompanyFunctionalOrganization> addDefaultFunOrg(Long cid ,String hseDirectorName,String hseDirectorTel);

	/**
	 * 根据企业ID，删除所有的组织架构
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月27日-下午6:01:38
	 * @param cid
	 * @param loginStaffId
	 */
	void deleteFunOrgByCid(Long cid,Long loginStaffId);


	/**
	 * 获取企业的“职业卫生”的职能机构信息。
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月4日-下午3:33:55
	 * @param cid
	 * @return 未找到，返回null
	 */
	CompanyFunctionalOrganization getFunOrgEHS(Long cid);

	/**
	 *
	 * 获取企业指定时间的“职业卫生”的职能机构信息。
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月14日-下午5:09:44
	 * @param cid 企业ID
	 * @param year 年份
	 * @return
	 */
	CompanyFunctionalOrganization getFunOrgEHS(Long cid,int year);


	/**
	 * 获取企业的“职业卫生”管理的基础信息
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年11月24日-下午2:51:31
	 * @param cid
	 * @return 职业卫生管理机构的名称，如果没有则显示“无”，专职人数、兼职人数。
	 */
	CompanyFunOrgVo getEHSBasicInfo(Long cid);

	 /**
	  * 新增职业卫生类型的职能机构
	  * @param cid
	  * @param loginStaffId
	  * @return
	  */
	CompanyFunctionalOrganization addHealthOrg(Long cid, Long loginStaffId);

	 /**
      * 编辑职能机构基础信息
      *
      * @param organization
      * @param loginStaffId
      * @return
      */
	 Long editOrgBasic(CompanyFunctionalOrganization organization, Long loginStaffId);

	 /**
	  * 企业基础信息保存 更新成立文件
	  *
	  * @param cid
	  * @param establishFile
	  * @param manageOrg
	  * @param loginStaffId
	  */
	 void setEstablishFile(Long cid, String establishFile, String manageOrg, Long loginStaffId);

	 /**
	  * 批量查询企业职能机构信息
	  * @param cidList 企业列表
	  * @return 职能机构列表
	  */
	 List<CompanyFunctionalOrganization> getFuncOrgListByCidList(List<Long> cidList);
 }
