/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.company;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.compliance.vo.CertTrainStaffInfoVo;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberLog;
import cn.smarthse.modules.health.vo.base.company.HealthManagementInfoVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;


/**
 *
 * 《xxxService》
 *
 *
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 11:51
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ICompanyFunctionalOrganizationMemberService extends IBaseService<CompanyFunctionalOrganizationMember>{


	/**
	 *
	 *
	 * @Comments:  根据只能机构ID，获取只能机构的成员
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月10日-上午10:40:58
	 * @param funOrgId
	 * @return
	 */
	List<CompanyFunctionalOrganizationMember> getMemberListByFunOrgId(Long funOrgId);

	/**
	 * @description: 根据企业id列表，批量获取职能机构的成员信息列表。
	 * @version: 卫企合规
	 * @date: 2024-04-24 17:20
	 * @param: 传参说明：
	 * 		cidList -> 企业id列表
	 * 		isComplianceManager -> 是否为合规管理人员，true-是
	 * @return: {@link List<CompanyFunctionalOrganizationMember>} 职能机构成员信息列表
	 * @author: DengJia 18402894534@163.com
	 */
	List<CompanyFunctionalOrganizationMember> getComplianceMemberListByCidList(List<Long> cidList, Boolean isComplianceManager);

	/**
	 * 根据职能机构ID，获取职能机构的人员分页信息
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月21日-下午6:25:52
	 * @param funOrgId
	 * @return
	 */
	PageInfo<CompanyFunctionalOrganizationMember> getMemberPageInfoByFunOrgId(Long funOrgId,JqGridParam param);

	/**
	 * 根据职能机构ID，获取职能机构的人员分页信息
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月21日-下午6:25:52
	 * @param funOrgId
	 * @return
	 */
//	PageInfo<CompanyFunOrgMemberVo> getMemberVoPageInfoByFunOrgId(Long funOrgId,JqGridParam param);

	/**
	 * 根据只能机构ID，获取职能机构的人员列表
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月4日-下午2:34:21
	 * @param funOrgId
	 * @return
	 */
//	List<CompanyFunOrgMemberVo> getMemberVoListByFunOrgId(Long funOrgId);

	/**
	 *
	 *
	 * @Comments:  根据职能机构ID，获取该机构成员数量
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月11日-上午10:59:44
	 * @param funOrgId
	 * @return
	 */
	Integer getMemberCountByFunOrgId(Long funOrgId);

	/**
	 * 删除组织机构成员及下所所有成员
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月21日-下午5:47:54
	 * @param memberId
	 * @param loginStaffId
	 */
	void deleteFunOrgMember(Long memberId,Long loginStaffId);

     void updateById(CompanyFunctionalOrganizationMember member, Long loginStaffId);

     CompanyFunctionalOrganizationMember getMemberByStaffId(Long staffId,Long funOrgId);

	 /**
	  * 编辑管理机构人员
	  *
	  * @param member
	  * @param loginStaffId
	  * @return
	  */
	 Long updateOrgStaff(CompanyFunctionalOrganizationMember member, Long loginStaffId);

	/**
	 * 添加操作记录
	 *
	 * @param newMember
	 * @param oldMember
	 * @param loginStaffId
	 */
	 void addOperateRecord(CompanyFunctionalOrganizationMember newMember, CompanyFunctionalOrganizationMember oldMember, Long loginStaffId);

	/**
	 * 人员操作记录查看
	 *
	 * @param search
	 * @param page
	 * @return
	 */
	 PageInfo<CompanyFunctionalOrganizationMemberLog> operateRecords(CompanyFunctionalOrganizationMemberLog search, JqGridParam page);

	/**
	 * 根据企业id获取人员信息
	 *
	 * @param cid
	 * @param page
	 * @return
	 */
	PageInfo<CompanyFunctionalOrganizationMember> getPageListByCid(Long cid, JqGridParam page);

	List<HealthManagementInfoVo> getListHealthManagementInfoVo(List<Long> cidList, Map<String,Object> param);

	void batchAddMember(List<CompanyFunctionalOrganizationMember> memberAddList, Long loginUserId);
	void batchUpdateMember(List<CompanyFunctionalOrganizationMember> memberUpdateList, Long loginUserId);

	/**
	 * @description: 单个企业查询：证书培训人员信息
	 * @version: 卫企合规
	 * @date: 2024-05-24 16:48
	 * @param: 传参说明：
	 * 		cid -> 企业id
	 * 		isComplianceManager -> 是否查询合规企业管理人员
	 * @return: {@link List<CertTrainStaffInfoVo>} 证书培训人员列表
	 * @author: DengJia 18402894534@163.com
	 */
	List<CertTrainStaffInfoVo> getCertStaffListByCid(Long cid, Boolean isComplianceManager);

	/**
	 * 获取人员详情
	 * @param memberId
	 * @return
	 */
	CompanyFunctionalOrganizationMember getInfoById(Long memberId);

	void deleteOrgMember(Long memberId, Long loginStaffId);
}
