/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.company;

import java.util.List;

import cn.smarthse.util.common.excel.model.ExcelModel;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.vo.base.company.AreaWorkInfoParseVo;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-12 05:07
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ICompanyAreaService extends IBaseService<CompanyArea>{

	
	/**
	 * 获取建筑物分页信息（level 等于Constants.BUILDING_LEVEL）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月25日-下午4:13:10
	 * @param cid 企业id
	 * @param pageNum 第几页，从1开始
	 * @param pageSize 每页条数
	 * @param needBuildingInfo 是否需要返回建筑物信息
	 * @return
	 */
	PageInfo<CompanyArea> getBuildingPageInfoByCid(Long cid,int pageNum,int pageSize,boolean needBuildingInfo);
	
	/**
	 * 根据企业ID，获取建筑物数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月25日-下午2:07:33
	 * @param cid 企业ID
	 * @return
	 */
	Integer getBuildingNumByCid(Long cid);
	
	
	/**
	 * 根据企业ID，获取工作场所数量（工作场所+楼层）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月25日-下午2:15:28
	 * @param cid
	 * @return
	 */
	Integer getAreaNumByCid(Long cid);

	/**
	 * 
	 * 
	 * @Comments: 根据企业ID，获取企业区域列表
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年6月15日-下午4:10:35
	 * @param cid 企业ID
	 * @return
	 */
	List<CompanyArea> getListByCid(Long cid);
	
	/**
	 * 
	 * 根据企业ID，获取企业区域列表(第一级)
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年5月31日-下午5:37:23
	 * @param cid
	 * @return
	 */
	List<CompanyArea> getRootListByCid(Long cid);
	
	/**
	 * 获取子区域列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年5月31日-下午5:38:02
	 * @param pid
	 * @return
	 */
	List<CompanyArea> getChildListByPid(Long pid);
	
	/**
	 * 获取所有下级节点
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月20日-下午3:19:16
	 * @param pid
	 * @return
	 */
	List<CompanyArea> getChildrenListByPid(Long pid);
	
	/**
	 * 获取工作场所列表，包含该工作场所的所有祖先节点。
	 * @param cid 企业ID
	 * @param areaId 区域ID，如果为空，则显示所有。如果不为空，则显示该区域下的工作场所。
	 * @return
	 */
	List<CompanyArea> getWorkPlaceList(Long cid,JqGridParam param);
	
	
	/**
	 * 
	 * 
	 * @Comments:  获取工作场所的分页信息
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年6月26日-上午10:08:45
	 * @param cid
	 * @param param
	 * @return
	 */
	PageInfo<CompanyArea> getWorkPlacePageInfo(Long cid,JqGridParam param);
	
	/**
	 * 
	 * 
	 * @Comments:  导入区域
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年6月26日-下午4:16:02
	 * @param fileId 附件ID
	 * @return 成功导入区域后的区域ID列表
	 */
	List<CompanyArea> importAreaByFileId(Long fileId,Long loginStaffId,Long cid);
	
	/**
	 * 
	 * 
	 * @Comments: 导入区域
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年6月26日-下午4:20:29
	 * @param fileUrlPath 区域文件的url路径
	 * @return 成功导入区域后的区域ID列表
	 */
	List<CompanyArea> importAreaByUrlPath(String fileUrlPath,Long loginStaffId,Long cid);

	 /**
	  *
	  *
	  * @Comments: 导入区域 v2.10
	  * @author 邓力宾
	  * @since 2020年2月27日 14：09
	  * @param fileUrlPath 区域文件的url路径
	  */
	 void importAreaByUrlPathV2_10(String fileUrlPath,Long loginStaffId,Long cid);
	 /**
	  *
	  *
	  * @Comments: 导入区域 v2.10
	  * @author 邓力宾
	  * @since 2020年10月30日 11：35
	  */
	 void importArea(ExcelModel excelModel, Long loginStaffId, Long cid);

	/**
	 * 根据企业ID，删除所有的建筑物信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月27日-下午5:38:52
	 * @param cid 企业ID
	 * @param loginStaffId 当前登录用户
	 */
	void deleteAreaByCid(Long cid,Long loginStaffId);
	
	/**
	 * 获取建筑物数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月15日-下午4:55:59
	 * @param cid 企业ID
	 * @return
	 */
	Integer getBuildingCount(Long cid);
	
	/**
	 * 根据区域ID字符串，获取区域名称字符串
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月6日-下午3:05:37
	 * @param areaIds
	 * @return
	 */
	String getAreaNamesByAreaIds(String areaIds);
	
	
	/**
	 * 根据区域名称查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-21-下午3:58:10
	 * @param name
	 * @param cid 企业ID
	 * @return
	 */
	CompanyArea getAreaByName(String name,Long cid);
	 /**
	  * 根据区域名称查询
	  *
	  * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	  * @author gbx
	  * @since 2020-2-27 14:47
	  * @param name
	  * @param cid 企业ID
	  * @return
	  */
	CompanyArea getAreaByNameAndPid(String name, Long pid, Long cid);


	
	/**
	 * 查询区域
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年2月25日-下午9:40:00
	 * @param areaName 区域名称
	 * @param cid 企业ID
	 * @return
	 */
	List<CompanyArea> searchArea(String areaName,Long cid);
	
	/**
	 * 根据区域ID，获取区域路径名称
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月22日-上午10:13:20
	 * @param areaId
	 * @return
	 */
	String getTreePathNameByAreaId(Long areaId);
	
	/**
	 * 获取区域的完全名称
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年3月6日-下午3:21:31
	 * @param areaId
	 * @return
	 */
	String getAreaFullName(Long areaId);
	
	/**
	 * 根据treepath获取路径名称
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月22日-上午10:12:50
	 * @param treePath
	 * @return
	 */
	String getTreePathNameByTreePath(String treePath);
	
	/**
	 * 获取区域数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月25日-下午1:22:37
	 * @param cid
	 * @return
	 */
	Integer getAreaCountByCid(Long cid);
	
	/**
	 * 克隆区域
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月30日-下午4:36:20
	 * @param id 原区域ID
	 * @param name 新区域名称
	 * @param loginStaffId 登录用户
	 * @param cid 企业ID
	 * @return
	 */
	CompanyArea cloneArea(Long id,String name,Long loginStaffId,Long cid);
	
	/**
	 * 名称在同一级里面是否已经存在
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月30日-下午4:44:28
	 * @param pid 父ID 可以为空，
	 * @param cid 企业ID 不能为空
	 * @param name 区域名称 不能为空
	 * @return
	 */
	boolean hasName(Long pid,Long cid,String name,Long thisId);

	/**
	 * 拖动区域
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年12月4日-下午5:34:20
	 * @param areaId
	 * @param targetId
	 * @param moveType
	 * @return
	 */
	ResponseData<String> drag(Long areaId,Long targetId,String moveType,Long loginStaffId);


	 /**
	  * 场所清单（所有）
	  * @return
	  */
	List<CompanyArea> getExportCompanyArea(long cid);
	 /**
	  * 场所清单(根据pid)
	  * @return
	  */
	List<CompanyArea> getExportCompanyAreaByPid(long pid);

	 /**
	  * 查询区域的岗位信息
	  * @param areaIds
	  * @return
	  */
	PageInfo<AreaWorkInfoParseVo> getAreaWorkInfo(List<Long> areaIds, int pageNum, int pageSize);

	 /**
	  * 区域排序
	  * @param areaIds 区域id 逗号隔开
	  * @param sortNums 排序号 逗号隔开
	  */
	 void sortArea(String areaIds, String sortNums);

    /**
     * @Comments:  <根据工作场所名+treePath 获取 公众场所信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/3/2-11:20
     * @param areaName
     * @param treePath
     * @param cid
     * @return cn.smarthse.modules.health.entity.base.company.CompanyArea
    */
	public CompanyArea getCompanyAreaByNameAndTreePath(String areaName, String treePath, Long cid);

	 public Long parseAreaName(String areaName,String separator, Long cid);
 }
