package cn.smarthse.modules.health.service.base.company;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;

import java.util.List;

/**
 *
 */
public interface CompanyReportInfoService extends IBaseService<CompanyReportInfo> {

    public CompanyReportInfo getCompanyReportInfoByCid(Long cid);

    List<CompanyReportInfo> getCompanyReportInfoByCids(List<Long> cids);
    /**
     * @Comments:  <用人单位落实职业病防治责任自查和风险评估报告编辑 同步数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/3/24-10:35
     * @param reportInfo
     * @param cid
     * @return cn.smarthse.modules.health.entity.base.company.CompanyReportInfo
    */
    public CompanyReportInfo updateCompanyReportInfo(CompanyReportInfo reportInfo,Long staffId, Long cid);

    /**
     * @Comments:  <自查报告编辑保存时调用该接口， 更新企业基础信息（冗余字段） >
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/3/24-15:19
     * @param reportInfo
     * @param cid
     * @param loginUserType 登录来源（0 or null - 正常登录；1 - 监管登录）
     * @return cn.smarthse.modules.health.entity.base.company.CompanyReportInfo
     */
    public CompanyReportInfo addCompanyReportInfo(CompanyReportInfo reportInfo, Long staffId, Long cid, String loginUserType);


    public List<CompanyReportInfo> listCompanyReportInfoHarmCountIsZero();

    /**
     * 获取 职工总人数（含劳务派遣等）
     * @param cid
     * @return {@code Integer }
     * @author zhangxu
     * @date 2024-04-26
     */
    Integer getCompanyReportInfoStaffCount(Long cid);

    /**
     * 不会验证是否是修改的数据，要确保该数据是新增的
     * @param reportInfo
     * @param staffId
     * @param cid
     * @return
     */
    public CompanyReportInfo addCompanyReportInfoNoVerificationRequired(CompanyReportInfo reportInfo,Long staffId, Long cid);
}
