/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.busilog.RecordOperationLogVo;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.entity.base.Company;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.entity.statistics.CompanyGradeAreaModel;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import cn.smarthse.modules.platform.model.CorpInfoModel;
import com.github.pagehelper.PageInfo;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;


 /**
 *
 * 《xxxService》
 *
 *
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-05-31 02:24
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICompanyService extends IBaseService<Company>{

	/**
	 *
	 *
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月15日-下午1:37:11
	 * @param company
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public Company saveOrUpdateCompany(Company company, Long loginStaffId,Long cid) throws Exception;

	public Company getCompanyById(Long id) throws Exception;
	/**
	 * 通过平台企业信息创建企业
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-19-下午2:30:38
	 * @param corpInfo
	 * @return	返回企业实体
	 */
	Company addCompanyByCorpInfoModel(CorpInfoModel corpInfo);

	/**
	 *
	 *
	 * @Comments:  <获取档案中每个企业的基本信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年9月5日-上午10:03:27
	 * @param cid
	 * @return
	 */
	public CompanyArchiveVo getCompanyArchiveInfo(Long cid) ;

	/**
	 *
	 *
	 * @Comments:  <根据档案给定年份 获取档案中每个企业的基本信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年11月15日-上午10:43:56
	 * @param cid
	 * @param year 年份
	 * @return
	 */
	public CompanyArchiveVo getCompanyArchiveInfo(Long cid , int year) ;

	/**
	 * 通过平台企业信息修改企业
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-10-13-上午11:14:17
	 * @param corpInfo
	 * @return
	 */
	void updateCompanyByCorpInfoModel(CorpInfoModel corpInfo,Long cid);


	/**
	 * @Comments:  <获取加入监管的企业列表>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2019/5/20-16:02
	 * @param
	 * @return java.util.List<cn.smarthse.modules.health.entity.base.Company>
	*/
	public List<CompanySuperviseModel> listSuperviseCompanyData();


	 public void updateReport() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException;

	 public Integer countSuperviseCompanyData();

	 public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize);

     Company getByName(String companyName, String isActualize);

	 List<Long> getCids(int pageNum, int pageSize,Long cid);
	 List<Long> getCids(Long cid);

	 List<String> getUnifiedSocialCcsList(int pageNum, int pageSize,String unifiedSocialCcs);

	 Map<String, Company> getUnifiedSocialCcsAndCidMap(int pageNum, int pageSize, String unifiedSocialCcs);

	 /**
	  * 判断企业是否开展职业病危害因素在线监测、监控
	  * @param cidList 待判断的企业id
	  * @return 开展监测、监控的企业id
	  */
	 List<Long> judgeIsJcAndJk(List<Long> cidList);

	 /**
	  * 判断企业是否积极配合并建成职业卫生实训基地
	  * @param cidList 待判断的企业id
	  * @return 积极配合并建成职业卫生实训基地的企业id
	  */
	 List<Long> judgeIsCompanyTrainingBase(List<Long> cidList);

	 /**
	  * 判断企业是否当年度使用“浙里卫企”直通车
	  * @param cidList 待判断的企业id
	  * @return 当年度使用“浙里卫企”直通车的企业id
	  */
	 List<Long> judgeIsCurrentYearUseThroughTrain(List<Long> cidList);

	 PageInfo<RecordOperationLogVo> getIndustryHisList(JqGridParam pageParam,Long cid);

     /**
      * 通过统一信用代码获取企业列表(目前只有id)
      * @param againCodeList
      * @return
      */
     List<Company> getListByUnifiedSocialCc(List<String> againCodeList);

     /**
      * 获取企业纳入分类相关统计数据
      * @param searchParam
      * @return
      */
     PageInfo<CompanyGradeAreaModel> statisticCompanyGradeListPage(SearchParam searchParam);

     /**
      * 获取企业纳入分类相关统计数据总计数据
      * @param searchParam
      * @return
      */
     CompanyGradeAreaModel statisticCompanyGradeHeadData(SearchParam searchParam);

     List<CompanyGradeAreaModel> statisticCompanyGradeList(SearchParam param);
 }

