/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base;


import java.util.List;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.BusinessNo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;


/**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author yanao
 * @since 2017-06-26 03:18
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IBusinessNoService extends IBaseService<BusinessNo>{

	List<BusinessNo> list(Long cid, String businessType,String day);
	
	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年6月26日-下午5:35:33
	 * @param cid 企业id
	 * @param businessType 业务类型（调用BusinessNoTypeEnum中的类型，如无类型请自行添加到该枚举中）
	 * @return 正常返回：业务编号+年月日+四位序列号累加+四位随机数字或字母
	 * @return 异常返回：除业务编号外其余不变（LC开头缺少企业id，LT开头缺少业务类型，GE开头表示生产中出现异常）
	 */
	String getBusinessNo(Long cid,String businessType);

	
	/**
	 * 
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-8-下午5:40:49
	 * @param cid
	 * @param businessType
	 * @return
	 * @return 异常返回：除业务编号外其余不变（LC开头缺少企业id，LT开头缺少业务类型，GE开头表示生产中出现异常）
	 */
	String getDocNo(Long cid,String businessType,String year);

	 public String getNewDocNo(Long cid, String businessType, String year);

	 List<LiteArchiveFilePersonal> getPersonalDocNo(List<LiteArchiveFilePersonal> personalList);
 }
