package cn.smarthse.modules.health.service.archive;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.archive.LiteArchiveLastdateCollector;
import cn.smarthse.modules.health.model.litearchive.AddLiteArchiveModel;
import cn.smarthse.modules.health.model.litearchive.LiteArchiveLastdateCollectorModel;

import java.util.List;

public interface ILiteArchiveLastdateCollectorService extends IBaseService<LiteArchiveLastdateCollector> {

    public void resetliteArchiveLastdateCollector();

    public void processArchiveLastDate();

    public void updateLiteArchiveLastdateCollector(List<LiteArchiveLastdateCollector> liteArchiveLastdateCollectors);
    public void processArchive201();
    public void processArchive202();
    public void processArchive204();
    public void processArchive206();
    public void processArchive210();
    public void processArchive211();
    public void processArchive216();
    public void processArchive302();
    public void processArchive303();
    public void processArchive404();
    public void processComplianceUpdate();
    public void processRefreshArchive();

    public List<LiteArchiveLastdateCollectorModel> selectRefreshCollector();

    /**
     * @description 需要增加的档案
     * @author zhoulj(1210172780@qq.com)
     * @date 2025/6/24 9:11
     * @param prevYear
     * @param currYear
     * @param cids
     * @return java.util.List<cn.smarthse.modules.health.model.litearchive.AddLiteArchiveModel>
     */
    public List<AddLiteArchiveModel> selectAddLiteArchiveModel(String currYear,
                                                               List<Long> cids);

}
