/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.archive;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.archive.Archive;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.entity.archive.ArchiveYear;
import cn.smarthse.modules.health.enums.archive.ArchiveType;


 /**
 * 
 * 《档案Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-09-01 10:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IArchiveService extends IBaseService<Archive>{

	/**
	 * 根据CID+档案类型+档案参数
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-4-下午3:49:48
	 * @param archiveCheck				根据自检任务读取档案主表
	 * @return
	 */
	Archive getArchiveByCheck(ArchiveCheck archiveCheck);

	/**
	 * 更新主表检测结果
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-4-下午4:00:08
	 * @param archiveCheck			自检调度
	 * @param checkState				自检结果状态
	 * @param checkResult			自检结果说明
	 * @param docCheckPercent	自检结果检测百分比
	 * @param cumsumCount		是否自动增加版本数
	 * @return 档案主表
	 */
	Archive updateArchive(ArchiveCheck archiveCheck, byte checkState,
			Integer docCheckPercent, boolean cumsumCount);

	/**
	 * 更新档案生成结果
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-7-下午3:18:12
	 * @param archiveGen
	 * @param generatorState
	 * @return
	 */
	Archive updateArchiveGenerator(ArchiveGenerator archiveGen,
			byte generatorState);
	
	
	/**
	 * 根据CID+档案类型+档案参数
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-6-下午3:52:19
	 * @param cid									企业编号
	 * @param docType							档案类型
	 * @param docParamValue				档案参数
	 * @return
	 */
	Archive getArchive(Long cid, byte docType, String docParamValue);


	/**
	 * 创建档案主表
	 * , Byte checkState, Long docCheckId, Byte docGeneratorState, Long docGenId 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-6-下午4:40:32
	 * @param cid							企业编号
	 * @param docType					档案类型
	 * @param docParamValue		档案参数
	 * @param createBy					发起人
	 * @return
	 */
	Archive addArchive(Long cid, byte docType, String docParamValue, Long createBy);

	

	/**
	 * 根据cid、档案类型查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-7-下午2:58:46
	 * @param cid 企业编号
	 * @param type ArchiveType
	 * @return
	 */
	PageInfo<Archive> getArchiveByDocType(JqGridParam param,ArchiveType type);
	
	
	/**
	 * 根据cid、类型查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-23-下午1:53:14
	 * @param cid
	 * @param docType
	 * @return
	 */
	Archive getArchiveByCid(Long cid, byte docType);

}
