/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.archive;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;


 /**
 * 
 * 《档案生成调度Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-09-01 10:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IArchiveGeneratorService extends IBaseService<ArchiveGenerator>{

	/**
	 *  获取一条待生成的档案任务
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-4-上午9:39:30
	 * @return
	 */
	ArchiveGenerator getArchiveGenerator();

	/**
	 * 读取待生成档案数
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @param cid 
	 * @since 2017-9-7-下午1:27:35
	 * @return
	 */
	int getArchiveGeneratorCount(Long cid);

	/**
	 *  更新生成状态
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-7-下午3:13:07
	 * @param archiveGen				生成任务调度
	 * @param generatorState		生成结果	
	 * @param generatorDes			生成结果说明
	 */
	void updateGeneratorState(ArchiveGenerator archiveGen, byte generatorState,
			String generatorDes);

	/**
	 * 判断档案是否已在自检
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-6-下午3:59:10
	 * @param cid
	 * @param docType
	 * @param docParamValue
	 * @return
	 */
	boolean existGeneratorJob(Long cid, byte docType, String docParamValue);
	
	/**
	 * 生成队列中的一项任务
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-8-下午1:05:02
	 */
	void generatorArchive();

	/**
	 * 生成自检档案
	 * <li>必须得有archiveId
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-6-下午4:20:32
	 * @param cid								企业编号
	 * @param docType						档案类型
	 * @param docParamValue			档案参数
	 * @param createBy						创建人
	 */
	ArchiveGenerator createGeneratorJob(Long cid, byte docType, String docParamValue, Long createBy,String title,String archiveId);
	
	
	/**
	 * 根据archiveId查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-21-下午3:27:55
	 * @param archiveId
	 * @return
	 */
	ArchiveGenerator getGeneratorByArchiveId(Long archiveId);

}
