/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.archive;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.archive.ArchiveFiles;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.entity.archive.ArchiveYear;
import cn.smarthse.modules.health.enums.archive.ArchiveType;


 /**
 * 
 * 《档案生成结果Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-09-01 10:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IArchiveFilesService extends IBaseService<ArchiveFiles>{

	/**
	 * 查询档案列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-8-上午9:14:44
	 * @param archiveId 档案主表id
	 * @param cid 企业编号
	 * @param paramValue 档案生成参数值
	 * @param type 档案类型
	 * @return
	 */
	List<ArchiveFiles> getListByArchiveId(Long archiveId,Long cid,String paramValue,Byte type);
	
	
	/**
	 * 列表数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-8-下午3:47:05
	 * @param param
	 * @param archiveId
	 * @return
	 */
	PageInfo<ArchiveFiles> getArchiveFilesList(JqGridParam param,Long archiveId);
	
	/**
	 * 保存档案记录
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-8-下午1:59:21
	 * @param afile
	 * @param dataJson
	 */
	void addArchiveFile(ArchiveFiles afile, String dataJson);


	/**
	 * 根据档案id查询档案文件
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-9-下午3:11:32
	 * @param cid
	 * @param archiveId
	 * @return
	 */
	List<ArchiveFiles> getArchiveFilesByArchiveId(Long cid,Long archiveId);
	
	
	Integer getByValue(Long cid,Long archiveId,String value);
	
	
	/**
	 * 根据ids查询列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-22-下午3:50:23
	 * @param ids
	 * @return
	 */
	List<ArchiveFiles> getListByFileIds(List<String> fileIds);
	
	
	/**
	 * 根据cid查询列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-22-下午4:30:35
	 * @param cid
	 * @return
	 */
	List<ArchiveFiles> getListByCid(Long cid,String type);
	
	
	/**
	 * 根据archiveId、生成id查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-23-上午9:58:44
	 * @param archiveId
	 * @param genId
	 * @return
	 */
	List<ArchiveFiles> getListByGenId(Long archiveId,Long genId);


	/**
	 * 读取生成档案版本数
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-25-下午2:38:15
	 * @param archiveGen
	 * @return
	 */
	int getCountArchiveFiles(ArchiveGenerator archiveGen);
	
}
