/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.archive;

import org.springframework.transaction.annotation.Transactional;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.enums.archive.ArchiveType;


 /**
 * 
 * 《档案自检结果调度Service》	
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-09-01 10:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IArchiveCheckService extends IBaseService<ArchiveCheck>{

	/**
	 * 读取档案队列数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @param cid 
	 * @since 2017-9-7-下午1:25:51
	 * @return
	 */
	int getArchiveCheckCount(Long cid);
	
	/**
	 * 读取待自检任务
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-4-下午12:51:02
	 * @return
	 */
	ArchiveCheck getArchiveCheck();

	/**
	 * 更新自检状态类型
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-4-下午1:00:13
	 * @param archiveCheck		自检任务实体
	 * @param checkState			检测结果
	 * @param checkResult		检测结果描述
	 * @param docCheckPercent		检测结果百分比,100表示完整,0-99表示不完整
	 * @param cumsumCount	自动增加版本修改
	 */
	void updateCheckState(ArchiveCheck archiveCheck, byte checkState, String checkResult , Integer docCheckPercent, boolean cumsumCount);

	
	/**
	 * 检测档案
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-4-下午5:09:33
	 */
	void checkArchive();

	/**
	 * 判断档案是否已在自检
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-6-下午3:59:10
	 * @param cid
	 * @param docType
	 * @param docParamValue
	 * @return
	 */
	boolean existCheckJob(Long cid, byte docType, String docParamValue);

	/**
	 * 生成自检档案
	 * <li>必须得有archiveId
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-6-下午4:20:32
	 * @param cid								企业编号
	 * @param docType						档案类型
	 * @param docParamValue			档案参数
	 * @param createBy						创建人
	 */
	ArchiveCheck createCheckJob(Long cid, byte docType, String docParamValue, Long createBy,String title,String archiveId);

	
	/**
	 * 根据档案生成id查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-23-下午1:48:56
	 * @param archiveId
	 * @return
	 */
	ArchiveCheck getCheckByArchiveId(Long archiveId,String value);
	
	
	/**
	 * 根据档案类型统计自检数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-27-下午3:16:06
	 * @param cid
	 * @return
	 */
	Integer getDocCheckContent(Long cid, byte docType);
	
	/**
	 * 获取自检完成的数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月14日-下午3:20:01
	 * @param cid
	 * @param docType
	 * @return
	 */
	int getDocCheckFinishedCount(Long cid ,ArchiveType docType);
}
