/**
 * 
 */
package cn.smarthse.modules.health.service.archive;


import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.archive.view.ArchiveView;
import cn.smarthse.modules.health.vo.archive.ArchiveJobCount;

/**
 *  《档案自检数据Service接口》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-5-下午2:42:05
 */
public interface ArchiveViewService {

	/**
	 * 根据设定参数获取建设项目职业卫生“三同时”档案列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-5-下午2:43:03
	 * @param gparam
	 * @return
	 */
	PageInfo<ArchiveView> getDoc1(JqGridParam gparam);
	
	/**
	 * 获取正在进行的档案列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @param cid 
	 * @since 2017-9-7-下午1:19:58
	 * @return
	 */
	ArchiveJobCount getArchiveJobCount(Long cid);

	/**
	 * @Comments:  <controller 层获取档案2 的数据>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018/12/10-14:55
	 * @param cid
	 * @param docParamValue
	 * @return Map<String,Object>
	*/
	Map<String, Object> getDoc2Data(Long cid, String docParamValue);
	public Map<String, Object> getListCompanyInspection(Long cid, long inspectionId);
	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年12月17日-上午11:16:32
	 * @param cid
	 * @param docParamValue
	 * @return
	 */
	Map<String, Object> getDoc3Data(Long cid, String docParamValue);

	
	/**
	 * 获取档案6的数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年12月17日-下午5:15:26
	 * @param cid
	 * @param docParamValue
	 * @return
	 */
	public Map<String, Object> getDoc6Data(Long cid, String docParamValue);
	
	/**
	 * 获取档案四的数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年12月19日-下午4:03:24
	 * @param cid
	 * @param docParamValue
	 * @return
	 */
	public Map<String, Object> getDoc4Data(Long cid, String docParamValue);
}
