package cn.smarthse.modules.health.pojo;

import cn.smarthse.common.util.number.NumberUtil;
import lombok.Data;

import java.io.Serializable;


/**
 * 风险化解率统计 VO对象
 *
 * @author wuxq
 * @since 2023年3月9日-上午9:39:16
 */
@Data
public class RiskSolveRateStatisticVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 区域id
     */
    private String areaId;
    /**
     * 区域名称
     */
    private String areaName;
    /**
     * 区域名称
     */
    private String areaLevel;

    /**
     * 累计总风险数
     */
    private int riskReformTotalNum;
    /**
     * 累计已整改风险数
     */
    private int hasReformedTotalNum;
    /**
     * 本年度总险总数
     */
    private int currentRiskReformTotalNum;
    /**
     * 本年度已整改风险总数
     */
    private int currentHasReformedTotalNum;
    /**
     * 本年度待整改风险总数
     */
    private int currentTobeReformedTotalNum;


    /**
     * 累计[乡镇协管]风险数
     */
    private int riskReformNum1;
    /**
     * 累计[乡镇协管]已整改风险数
     */
    private int hasReformedNum1;
    /**
     * 本年度累计[乡镇协管]风险数
     */
    private int currentRiskReformNum1;
    /**
     * 本年度累计[乡镇协管]已整改风险数
     */
    private int currentHasReformedNum1;
    /**
     * 本年度累计[乡镇协管]整改率
     */
    private String currentHasReformedRate1;
    /**
     * 本年度未巡查企业数
     */
    private int unPatrolCompanyCurrNum;
    /**
     * 未巡查企业数
     */
    private int unPatrolCompanyTotalNum;


    /**
     * 累计[服务管家]风险数
     */
    private int riskReformNum2;
    /**
     * 累计[服务管家]已整改风险数
     */
    private int hasReformedNum2;
    /**
     * 本年度累计[服务管家]风险数
     */
    private int currentRiskReformNum2;
    /**
     * 本年度累计[服务管家]已整改风险数
     */
    private int currentHasReformedNum2;


    /**
     * 累计[主体履责]风险数
     */
    private int riskReformNum3;
    /**
     * 累计[主体履责]已整改风险数
     */
    private int hasReformedNum3;
    /**
     * 本年度累计[主体履责]风险数
     */
    private int currentRiskReformNum3;
    /**
     * 本年度累计[主体履责]已整改风险数
     */
    private int currentHasReformedNum3;


    /**
     * 累计[智能评估]风险数
     */
    private int riskReformNum4;
    /**
     * 累计[智能评估]已整改风险数
     */
    private int hasReformedNum4;
    /**
     * 本年度累计[智能评估]风险数
     */
    private int currentRiskReformNum4;
    /**
     * 本年度累计[智能评估]已整改风险数
     */
    private int currentHasReformedNum4;

    //累计总风险数/化解率；
    private String riskNumRateTotal;
    //当年总风险数/化解率；
    private String currentRiskNumRateTotal;

    //累计乡镇协管风险数/化解率
    private String riskNumRate1;
    //当年乡镇协管风险数/化解率
    private String currentRiskNumRate1;

    //累计服务管家风险数/化解率
    private String riskNumRate2;
    //当年服务管家风险数/化解率
    private String currentRiskNumRate2;

    //累计主体履责风险数/化解率
    private String riskNumRate3;
    //当年主体履责风险数/化解率
    private String currentRiskNumRate3;

    //累计智能评估风险数/化解率
    private String riskNumRate4;
    //当年智能评估风险数/化解率
    private String currentRiskNumRate4;

    public String getCurrentHasReformedRate1() {
        if (this.currentRiskReformNum1 > 0 && this.currentHasReformedNum1 > 0) {
            return NumberUtil.rateProcessing(this.currentHasReformedNum1, (this.currentRiskReformNum1 + this.unPatrolCompanyCurrNum * 4));
        }
        return "-";
    }

    public String getRiskNumRateTotal() {
        String r = String.valueOf(this.riskReformTotalNum);
        if (this.riskReformTotalNum > 0 && this.hasReformedTotalNum > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.hasReformedTotalNum, this.riskReformTotalNum));
        }
        return r.concat("/-");
    }

    public String getCurrentRiskNumRateTotal() {
        String r = String.valueOf(this.currentRiskReformTotalNum);
        if (this.currentRiskReformTotalNum > 0 && this.currentHasReformedTotalNum > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.currentHasReformedTotalNum, this.currentRiskReformTotalNum));
        }
        return r.concat("/-");
    }

    public String getRiskNumRate1() {
        String r = String.valueOf(this.riskReformNum1);
        if (this.riskReformNum1 > 0 && this.hasReformedNum1 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.hasReformedNum1, (this.riskReformNum1 + this.unPatrolCompanyCurrNum * 4)));
        }
        return r.concat("/-");
    }

    public String getCurrentRiskNumRate1() {
        String r = String.valueOf(this.currentRiskReformNum1);
        if (this.currentRiskReformNum1 > 0 && this.currentHasReformedNum1 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.currentHasReformedNum1, (this.currentRiskReformNum1 + this.unPatrolCompanyCurrNum * 4)));
        }
        return r.concat("/-");
    }

    public String getRiskNumRate2() {
        String r = String.valueOf(this.riskReformNum2);
        if (this.riskReformNum2 > 0 && this.hasReformedNum2 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.hasReformedNum2, this.riskReformNum2));
        }
        return r.concat("/-");
    }

    public String getCurrentRiskNumRate2() {
        String r = String.valueOf(this.currentRiskReformNum2);
        if (this.currentRiskReformNum2 > 0 && this.currentHasReformedNum2 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.currentHasReformedNum2, this.currentRiskReformNum2));
        }
        return r.concat("/-");
    }

    public String getRiskNumRate3() {
        String r = String.valueOf(this.riskReformNum3);
        if (this.riskReformNum3 > 0 && this.hasReformedNum3 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.hasReformedNum3, this.riskReformNum3));
        }
        return r.concat("/-");
    }

    public String getCurrentRiskNumRate3() {
        String r = String.valueOf(this.currentRiskReformNum3);
        if (this.currentRiskReformNum3 > 0 && this.currentHasReformedNum3 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.currentHasReformedNum3, this.currentRiskReformNum3));
        }
        return r.concat("/-");
    }

    public String getRiskNumRate4() {
        String r = String.valueOf(this.riskReformNum4);
        if (this.riskReformNum4 > 0 && this.hasReformedNum4 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.hasReformedNum4, this.riskReformNum4));
        }
        return r.concat("/-");
    }

    public String getCurrentRiskNumRate4() {
        String r = String.valueOf(this.currentRiskReformNum4);
        if (this.currentRiskReformNum4 > 0 && this.currentHasReformedNum4 > 0) {
            return r.concat("/").concat(NumberUtil.rateProcessing(this.currentHasReformedNum4, this.currentRiskReformNum4));
        }
        return r.concat("/-");
    }
}
