package cn.smarthse.modules.health.pojo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Denglibin
 * @date 2021/12/23 15:27
 * @desc
 */
@Data
public class HealthCheckArchiveStaffInfo implements Serializable {

    private Long id; //体检id
    private Date checkDate; //体检日期
    /**
     * 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    private Byte checkType;

    private String staffDeptName; //体检时部门名称

    private String staffWorkName; //体检时岗位名称


    private String harmFactor;//危害因素id 逗号隔开
    private String factorNames;//危害因素名称

    private String perhapsDiseaseNames=""; //可能导致的职业病

    private String examResult; //体检结论 (1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)

    private String dealDesc; //处理意见

    private Integer dealStatus;//处理状态（0未完成 1企业已上报）

    private Long staffId; //人员id
    private Integer gender; //0:女 1：男;//性别 男女

    private String realName; //姓名

    private String icCard;//身份证号

    private Integer age;//年龄

}
