package cn.smarthse.modules.health.pojo;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Denglibin
 * @date 2021/12/22 14:32
 * @desc 体检档案 体检结果汇总表 附件 vo
 */
@Data
public class HealthCheckArchiveFileVo implements Serializable {
    private Long id; //体检id
    private String checkDate; //体检日期
    private Long hospital; //体检机构id
    private String hospitalName; //机构名称

    private String checkTypeName; //体检种类

    private Integer needCheckNum; //应检人数

    private Integer checkNum; //实检人数

    //1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常
    private Integer result1Num = 0; //正常人数
    private Integer result2Num = 0; //复查人数
    private Integer result3Num = 0; //疑似职业病人数
    private Integer result4Num = 0; //职业禁忌症人数
    private Integer result5Num = 0; //其他疾病或异常人数




}
