package cn.smarthse.modules.health.model.phyphcCheck;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @ author Supw
 * @ since 2024/11/19 17:23
 */
@Data
public class CheckSubmitModel implements java.io.Serializable{

    private Long checkId;

    private String checkWorkName;
    //实际用工单位名称
    private String actualEmployerName;
    private String actualEmployerCreditCode;
    private Long actualEmployerId;
    //委托单位名称
    private String entrustEmployerName;
    private String entrustEmployerCreditCode;
    private Long entrustEmployerId;
    //体检机构信息
    private String orgName;
    private Long orgId;

    //体检类型
    private Integer bodyCheckType;
    //是否包含复查
    private Boolean isRecheck;
    //体检时间
    @DateTimeFormat(pattern="yyyy-mm-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date checkDateBegin;
    @DateTimeFormat(pattern="yyyy-mm-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date checkDateEnd;
    //体检地址
    private String checkAddress;
    //应检人数
    private Integer numberOfShouldCheck;
    //实检人数
    private Integer numberOfRealCheck;
    //体检项目
    private String checkItems;
    //职业健康检查报告
    private Long checkReportFileId;

    private Boolean isSubmit=false;


    public List<String> checkEmptyFields() {
        List<String> emptyFields = new ArrayList<>();


        if (checkWorkName == null || checkWorkName.isEmpty()) {
            emptyFields.add("checkWorkName");
        }

        if (actualEmployerId == null) {
            emptyFields.add("actualEmployerId");
        }

        if (entrustEmployerId == null) {
            emptyFields.add("entrustEmployerId");
        }
        if (bodyCheckType == null) {
            emptyFields.add("bodyCheckType");
        }
        if (isRecheck == null) {
            emptyFields.add("hasFc");
        }
        if (checkDateBegin == null) {
            emptyFields.add("checkDateBegin");
        }
        if (checkDateEnd == null) {
            emptyFields.add("checkDateEnd");
        }
        if (checkAddress == null || checkAddress.isEmpty()) {
            emptyFields.add("checkAddress");
        }
        if (numberOfShouldCheck == null) {
            emptyFields.add("numberOfShouldCheck");
        }
//        if (numberOfRealCheck == null) {
//            emptyFields.add("numberOfRealCheck");
//        }
        if (checkItems == null || checkItems.isEmpty()) {
            emptyFields.add("checkItems");
        }
        if (checkReportFileId == null) {
            emptyFields.add("checkReportFileId");
        }

        return emptyFields;
    }

}
