package cn.smarthse.modules.health.model.phyphcCheck;

import lombok.Data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @ author Supw
 * @ since 2024/11/20 9:32
 */
@Data
public class AddCheckStaffModel implements java.io.Serializable{

    private Long checkId;

    private Long checkStaffId;
    private Long cid;

    //姓名
    private String name;
    //证件号
    private String idCardCode;
    //证件类型
    private String idCardType;
    //性别
    private String sexCode;
    //年龄
    private Integer age;
    //出生日期
    private String birthday;
    //接害工龄
    private String hazardYear;
    private String hazardMonth;
    //岗位工种
    private String otherJobName;
    //体检危害因素
    private String contactHazardCode;
    private String contactHazardName;
    //主检结论
    private String checkResultCode;
    //异常指标
    private String anomalyItems;
    //主键建议
    private String suggest;
    //处理意见
    private String handlingOpinions;

    //体检结论编码 详情见 PhyPhcCheckConclusionEnum
    private String conclusion;

    //异常的体检危害因素（疑似职业病，职业禁忌症）
    private String abnormalHazardCode;
    //异常名称 （疑似职业病，职业禁忌症）
    private String abnormalName;
    //复查的项目 （复查）
    private String fcItem;

    private String sptId;
    private String cotId;


    public List<String> checkEmptyFields() {
        List<String> emptyFields = new ArrayList<>();

        if (checkId == null) {
            emptyFields.add("checkId");
        }
//        if (checkStaffId == null) {
//            emptyFields.add("checkStaffId");
//        }
        if (name == null || name.isEmpty()) {
            emptyFields.add("name");
        }
        if (idCardCode == null || idCardCode.isEmpty()) {
            emptyFields.add("idCardCode");
        }
        if (idCardType == null || idCardType.isEmpty()) {
            emptyFields.add("idCardType");
        }
        if (sexCode == null || sexCode.isEmpty()) {
            emptyFields.add("sexCode");
        }
        if (age == null) {
            emptyFields.add("age");
        }
//        if (birthday == null || birthday.isEmpty()) {
//            emptyFields.add("birthday");
//        }
        if (hazardYear == null || hazardYear.isEmpty()) {
            emptyFields.add("hazardYear");
        }
        if (hazardMonth == null || hazardMonth.isEmpty()) {
            emptyFields.add("hazardMonth");
        }
        if (otherJobName == null || otherJobName.isEmpty()) {
            emptyFields.add("otherJobName");
        }
        if (contactHazardCode == null || contactHazardCode.isEmpty()) {
            emptyFields.add("contactHazardCode");
        }
        if (checkResultCode == null || checkResultCode.isEmpty()) {
            emptyFields.add("checkResultCode");
        }
        if (Arrays.asList("3","4","5").contains(conclusion) && (anomalyItems == null || anomalyItems.isEmpty())) {
            emptyFields.add("anomalyItems");
        }
        if (suggest == null || suggest.isEmpty()) {
            emptyFields.add("suggest");
        }
        if (Arrays.asList("2","3","4").contains(conclusion) && (handlingOpinions == null || handlingOpinions.isEmpty())) {
            emptyFields.add("handlingOpinions");
        }
        if (conclusion == null || conclusion.isEmpty()) {
            emptyFields.add("conclusion");
        }
        if (Arrays.asList("3","4").contains(conclusion) &&(abnormalHazardCode == null || abnormalHazardCode.isEmpty())) {
            emptyFields.add("abnormalHazardCode");
        }
        if (Arrays.asList("3","4").contains(conclusion) && (abnormalName == null || abnormalName.isEmpty()) ) {
            emptyFields.add("abnormalName");
        }
        if ("2".equalsIgnoreCase (conclusion) &&(fcItem == null || fcItem.isEmpty())) {
            emptyFields.add("fcItem");
        }

        return emptyFields;
    }
}
