package cn.smarthse.modules.health.model.litearchive;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Denglibin
 * @date 2021/12/10 9:51
 * @desc 设备、材料（化学品）一览表
 */
@Data
public class DeviceMaterialHarm implements Serializable {

    private static final long serialVersionUID = 2256229378935506916L;

    private Integer type;//类型 1:设备 2：物料

    private Long id; //设备id（物料id）

    private String name; //设备、材料、化学品名称

    private String harmNames;//可能产生的职业病危害因素名称（多个）

    private String areaOrWorkName; //使用车间和岗位

    private String providerNames;//生产、供货单位

    private Date createDate; //创建日期

    public String getTypeName() {
        switch (type) {
            case 1:
                return "设备";
            case 2:
                return "物料";
            default:
                return "";
        }
    }

    /**
     * 是否要竖方向合并
     * <p>
     * 01 代表开始
     * 02 代表被合并
     */
    private String vertical = "00";
}