/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.uploader;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.smarthse.modules.uploader.FileMD5;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadState;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class FileUploadSimple {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUploadSimple.class);
    public static final int MAX_FILE_NAME_LENGTH = 128;

    public static void transferTo(MultipartFile fileData, String realPath) {
        if (!Files.exists(new File(realPath).toPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(new File(realPath).toPath(), new FileAttribute[0]);
                fileData.transferTo(new File(realPath));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static UploadFileParameter upload_pluploader(UploadFileParameter up) {
        try {
            MultipartFile file;
            HttpServletRequest request = up.getRequest();
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            if ((up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0L) && (file = multipartRequest.getFile("file")) != null && file.getSize() > 0L) {
                up.setMultipartFile(file);
            }
            if (up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0L) {
                up.setUploadState(UploadState.UPLOAD_ZEROSIZE);
                return up;
            }
            String realPath = up.getRealPath() + UploadFileParameter.FILE_PATH_SEP;
            File frealPath = new File(realPath);
            frealPath.mkdirs();
            String resourceFileName = up.getMultipartFile().getOriginalFilename();
            int length = resourceFileName.length();
            up.setOriginalFilename(length > 128 ? resourceFileName.substring(length - 128, length) : resourceFileName);
            up.setHashCode(FileMD5.getFileMD5(up.getMultipartFile().getBytes()));
            up.setFilesize(up.getMultipartFile().getSize());
            up.setFileExt(FilenameUtils.getExtension((String)resourceFileName));
            up.setFileName(FileUploadSimple.getNumberName(resourceFileName, up.getFileExt()));
            up.setFile(new File(realPath + up.getFileName()));
            up.setRealPath(realPath);
            up.setOssUrl((up.getUploadDir() + "/" + up.getFileName()).replace("\\", "/"));
            up.setOssDir(up.getUploadDir().replace("\\", "/"));
            up.setIp(JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            FileUtils.copyToFile((InputStream)up.getMultipartFile().getInputStream(), (File)up.getFile());
            up.setUploadState(UploadState.UPLOAD_SUCCSSS);
        }
        catch (Exception e) {
            log.error("IOException\uff1a", (Throwable)e);
        }
        return up;
    }

    public static String getDataSplitPath() {
        return new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd").format(new Date());
    }

    public static String getDataPath() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static String getMonthPath() {
        return new SimpleDateFormat("yyyyMM").format(new Date());
    }

    public static String getNumberName(String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return numberName + "." + defalutExds;
    }

    public static String getNumberName(String fileName, String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddhhmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return FileUploadSimple.getNewFileName(fileName, numberName, defalutExds);
    }

    public static String getNumberFile() {
        return new SimpleDateFormat("HHmmss").format(new Date()) + RandomUtil.randomNumbers((int)2);
    }

    public static String getNewFileName(String fileName, String newName, String nullSuffix) {
        String suffix = FilenameUtils.getExtension((String)fileName);
        newName = suffix != null ? newName.concat(".").concat(suffix) : newName.concat(".").concat(nullSuffix);
        return newName;
    }
}

