/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.enums.home.grade;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.util.StringUtils;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum GradeTagEnum {
    NOSOURCE("\u672a\u5206\u7c7b", 0),
    LESS3("\u63a5\u5bb3\u4e09\u4eba\u4ee5\u4e0b\u4f01\u4e1a", 1),
    BYREPORT("\u5206\u7c7b\u81ea\u67e5", 2),
    BYINDU("\u6839\u636e\u884c\u4e1a\u5212\u5206", 3),
    BYADJUST("\u4f9d\u636e\u5bb9\u9519\u81ea\u7ea0\u8c03\u6574", 4),
    SUPENDREFORM("\u98ce\u9669\u672a\u53ca\u65f6\u5316\u89e3", 5),
    CREDITSUPERVISE("\u4fe1\u7528\u76d1\u7ba1\u63d0\u6863", 6),
    ONLINE_DEVICE("\u5b89\u88c5\u5728\u7ebf\u76d1\u6d4b\u76d1\u63a7\u4f01\u4e1a", 61),
    TRAINING_BASE("\u53c2\u4e0e\u804c\u4e1a\u536b\u751f\u5b9e\u8bad\u57fa\u5730\u5efa\u8bbe", 62),
    COMPLIANCE("\u5408\u89c4\u8fbe\u6807\u4f01\u4e1a", 63),
    SUPERVISE_IDENTIFY("\u76d1\u7ba1\u8ba4\u5b9a", 8),
    LABOR_DISPATCH("\u4f9d\u636e\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d", 9);

    private String name;
    private Integer code;

    private GradeTagEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (GradeTagEnum c : GradeTagEnum.values()) {
            if (!c.getCode().equals(code)) continue;
            return c.name;
        }
        return null;
    }

    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return null;
        }
        for (GradeTagEnum c : GradeTagEnum.values()) {
            if (!c.getName().equals(name)) continue;
            return c.getCode();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static String getNoGradeSource(String gradeSource) {
        if (StrUtil.isNotBlank((CharSequence)gradeSource)) {
            List gradeSourceArr = StrUtil.split((CharSequence)gradeSource, (CharSequence)",");
            HashSet gradeSourceSet = new HashSet(gradeSourceArr);
            HashSet<CallSite> resultSet = new HashSet<CallSite>();
            for (GradeTagEnum value : GradeTagEnum.values()) {
                if (gradeSourceSet.contains(value.getCode())) continue;
                resultSet.add((CallSite)((Object)("" + value.getCode())));
            }
            return StrUtil.join((CharSequence)",", resultSet);
        }
        return null;
    }

    public static GradeTagEnum getEnum(Integer code) {
        return Arrays.stream(GradeTagEnum.values()).filter(s -> Objects.equals(s.getCode(), code)).findFirst().orElse(null);
    }
}

