/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.enums;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.util.StringUtils;

public enum CompanyBusinessState {
    NORMAL("\u6b63\u5e38\u8425\u4e1a", 1),
    STOP("\u6682\u505c\u8425\u4e1a", 2),
    CLOSE("\u5173\u505c", 0);

    private String name;
    private Integer code;

    private CompanyBusinessState(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public static String getName(Integer code) {
        if (code == null) {
            return "\u5df2\u5173\u505c";
        }
        for (CompanyBusinessState c : CompanyBusinessState.values()) {
            if (!Objects.equals(c.getCode(), code)) continue;
            return c.name;
        }
        return "\u5df2\u5173\u505c";
    }

    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return null;
        }
        for (CompanyBusinessState c : CompanyBusinessState.values()) {
            if (!c.getName().equals(name)) continue;
            return c.getCode();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static CompanyBusinessState getEnum(Integer code) {
        return Arrays.stream(CompanyBusinessState.values()).filter(s -> Objects.equals(s.getCode(), code)).findFirst().orElse(null);
    }
}

