/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.jqgrid;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class JqGridData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long total;
    private long page;
    private long records;
    private List<T> rows;

    public JqGridData() {
    }

    public JqGridData(PageInfo<T> rows) {
        if (rows != null && rows.getPageSize() > 0) {
            this.total = rows.getTotal() % (long)rows.getPageSize() == 0L ? rows.getTotal() / (long)rows.getPageSize() : (long)rows.getPages();
            this.page = rows.getPageNum();
            this.records = rows.getTotal();
            this.rows = rows.getList();
        }
    }

    public JqGridData(PageInfo<T> rows, JqGridParam param) {
        if (rows != null && param.getRows() > 0) {
            this.total = rows.getTotal() % (long)param.getRows() == 0L ? rows.getTotal() / (long)param.getRows() : rows.getTotal() / (long)param.getRows() + 1L;
            this.page = param.getPage();
            this.records = rows.getTotal();
            this.rows = rows.getList();
        }
    }

    public JqGridData(Page<T> rows, JqGridParam param) {
        if (rows != null && param.getRows() > 0) {
            this.total = rows.getTotal() % (long)param.getRows() == 0L ? rows.getTotal() / (long)param.getRows() : (long)rows.getPages();
            this.page = param.getPage();
            this.records = rows.getTotal();
            this.rows = rows;
        }
    }

    public JqGridData(List<T> allList, JqGridParam param) {
        int page = param.getPage();
        int size = param.getRows();
        this.page = page;
        if (allList == null) {
            allList = new LinkedList<T>();
        }
        this.total = allList.size() / size;
        if (allList.size() % size != 0) {
            ++this.total;
        }
        this.records = allList.size();
        LinkedList<T> l = new LinkedList<T>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); ++i) {
            l.add(allList.get(i));
        }
        this.rows = l;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public long getPage() {
        return this.page;
    }

    @Generated
    public long getRecords() {
        return this.records;
    }

    @Generated
    public List<T> getRows() {
        return this.rows;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    @Generated
    public void setPage(long page) {
        this.page = page;
    }

    @Generated
    public void setRecords(long records) {
        this.records = records;
    }

    @Generated
    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JqGridData)) {
            return false;
        }
        JqGridData other = (JqGridData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getRecords() != other.getRecords()) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JqGridData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        long $records = this.getRecords();
        result = result * 59 + (int)($records >>> 32 ^ $records);
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JqGridData(total=" + this.getTotal() + ", page=" + this.getPage() + ", records=" + this.getRecords() + ", rows=" + String.valueOf(this.getRows()) + ")";
    }
}

