/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre;

import cn.smarthse.modules.datacentre.JqGridParam;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class JqGridData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long total;
    private long page;
    private long records;
    private List<T> rows;

    public JqGridData() {
    }

    public JqGridData(PageInfo<T> rows, JqGridParam param) {
        if (rows != null && param.getRows() > 0) {
            this.total = rows.getTotal() % (long)param.getRows() == 0L ? rows.getTotal() / (long)param.getRows() : rows.getTotal() / (long)param.getRows() + 1L;
            this.page = param.getPage();
            this.records = rows.getTotal();
            this.rows = rows.getList();
        }
    }

    public JqGridData(Page<T> rows, JqGridParam param) {
        if (rows != null && param.getRows() > 0) {
            this.total = rows.getTotal() % (long)param.getRows() == 0L ? rows.getTotal() / (long)param.getRows() : (long)rows.getPages();
            this.page = param.getPage();
            this.records = rows.getTotal();
            this.rows = rows;
        }
    }

    public JqGridData(List<T> allList, JqGridParam param) {
        int page = param.getPage();
        int size = param.getRows();
        this.page = page;
        if (allList == null) {
            allList = new LinkedList<T>();
        }
        this.total = allList.size() / size;
        if (allList.size() % size != 0) {
            ++this.total;
        }
        this.records = allList.size();
        LinkedList<T> l = new LinkedList<T>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); ++i) {
            l.add(allList.get(i));
        }
        this.rows = l;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public long getRecords() {
        return this.records;
    }

    public void setRecords(Integer records) {
        this.records = records.intValue();
    }

    public long getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page.intValue();
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total.intValue();
    }
}

