/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.common.util;

import cn.smarthse.modules.datacentre.model.apps.NoiseCalcuModel;

public class NoiseCalcuUtil {
    public static NoiseCalcuModel calcu(NoiseCalcuModel model) {
        NoiseCalcuModel m = NoiseCalcuUtil.splitArray(model.getLaeqts(), model.getTs());
        Double[] lAeqTs = m.getLaeqt();
        Double[] T = m.getT();
        Double sum = 0.0;
        Double tSum = 0.0;
        for (int i = 0; i < T.length; ++i) {
            tSum = tSum + T[i];
            sum = sum + Math.pow(10.0, 0.1 * lAeqTs[i]) * T[i];
        }
        Double LAeqT = 10.0 * Math.log10(sum / tSum);
        Double T0 = 8.0;
        if (tSum > 24.0) {
            // empty if block
        }
        Double Te = tSum;
        Double LEX8h = LAeqT + 10.0 * Math.log10(Te / T0);
        Double De = model.getDe();
        Double LEX40h = 10.0 * Math.log10(Math.pow(10.0, 0.1 * LEX8h) * De / 5.0);
        model.setLEX8h(LEX8h);
        model.setLEX40h(LEX40h);
        return model;
    }

    public static String check(NoiseCalcuModel model) {
        String content = null;
        if (model == null) {
            content = "\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97!";
            return content;
        }
        if (model.getLaeqts() == null || model.getTs() == null) {
            content = "\u53c2\u6570\u4e0d\u5168\uff0c\u65e0\u6cd5\u8ba1\u7b97!";
            return content;
        }
        NoiseCalcuModel m = NoiseCalcuUtil.splitArray(model.getLaeqts(), model.getTs());
        Double[] lAeqT = m.getLaeqt();
        Double[] T = m.getT();
        Double Te = 0.0;
        for (int i = 0; i < T.length; ++i) {
            Te = Te + T[i];
        }
        if (lAeqT == null || T == null) {
            content = "\u53c2\u6570\u4e0d\u5168\uff0c\u65e0\u6cd5\u8ba1\u7b97!";
            return content;
        }
        Boolean isNull = true;
        Double tSum = 0.0;
        for (int i = 0; i < lAeqT.length; ++i) {
            if (lAeqT[i] == null || T[i] == null) continue;
            isNull = false;
            tSum = tSum + T[i];
        }
        if (isNull.booleanValue()) {
            content = "\u53c2\u6570\u4e0d\u5168\uff0c\u65e0\u6cd5\u8ba1\u7b97!";
            return content;
        }
        if (tSum > 24.0) {
            content = "\u8bf7\u586b\u5199\u6709\u6548\u7684\u63a5\u89e6\u573a\u6240\u65f6\u95f4!";
            return content;
        }
        if (Te > 24.0) {
            content = "\u6bcf\u5929\u5b9e\u9645\u5de5\u4f5c\u65f6\u95f4\u6570\u503c\u4e0d\u5408\u6cd5,\u8bf7\u91cd\u65b0\u586b\u5199!";
            return content;
        }
        if (model.getDe() == null) {
            content = "\u8bf7\u586b\u5199\u6bcf\u5468\u5b9e\u9645\u5de5\u4f5c\u65f6\u95f4!";
            return content;
        }
        if (model.getDe() > 7.0) {
            content = "\u6bcf\u5468\u5b9e\u9645\u5de5\u4f5c\u65f6\u95f4\u6570\u503c\u4e0d\u5408\u6cd5,\u8bf7\u91cd\u65b0\u586b\u5199!";
            return content;
        }
        return content;
    }

    private static NoiseCalcuModel splitArray(String laeqts, String ts) {
        String[] laeqtstr = laeqts.split(",");
        String[] tstr = ts.split(",");
        Integer index = 0;
        if (laeqtstr.length == tstr.length) {
            for (int i = 0; i < tstr.length; ++i) {
                if (laeqtstr[i] == null || tstr[i] == null) continue;
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        if (index == 0) {
            throw new RuntimeException("\u65e0\u6709\u6548\u6570\u636e,\u8ba1\u7b97\u5931\u8d25!!");
        }
        Double[] lAeqTs = new Double[index.intValue()];
        Double[] T = new Double[index.intValue()];
        Integer j = 0;
        if (laeqtstr.length == tstr.length) {
            for (int i = 0; i < tstr.length; ++i) {
                if (laeqtstr[i] == null || tstr[i] == null) continue;
                lAeqTs[j.intValue()] = Double.valueOf(laeqtstr[i]);
                T[j.intValue()] = Double.valueOf(tstr[i]);
                Integer n = j;
                Integer n3 = j = Integer.valueOf(j + 1);
            }
        }
        NoiseCalcuModel m = new NoiseCalcuModel();
        m.setLaeqt(lAeqTs);
        m.setT(T);
        return m;
    }
}

