package cn.smarthse.modules.training.provider;

import cn.smarthse.modules.training.model.UserIntegralModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 平台用户积分公共服务(由在线培训服务提供platform-training-service)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月18日 上午9:23:08
 */
public interface IUserIntegralProvideService {
	
	/**
	 * 查询用户的总积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param keyword : 模糊匹配关键字
	 * @return
	 */
	public PageInfo<UserIntegralModel> getUserIntegralModelList(int pageNum, int pageSize, String keyword);

	/**
	 * 查询指定用户的积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 用户平台账号id
	 * @return
	 */
	PageInfo<UserIntegralModel> getUserIntegralLogModelList(int pageNum, int pageSize, Long userId);
	
	/**
	 * 查询指定用户每天的积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 用户平台账号id
	 * @return
	 */
	public PageInfo<UserIntegralModel> getUserIntegralListGroupByDay(Integer pageNum, Integer pageSize, Long userId);
	
	/**
	 * 查询指定账号的每种积分类型当天的状态
	 * @param userId : 用户平台账号id
	 * @return
	 */
	List<UserIntegralModel> getUserIntegralLogModelByType(Long userId);
	
	/**
	 * 查询指定账号总积分
	 * @param userId : 用户平台账号id
	 * @return
	 */
	public Integer getIntegralSum(Long userId);

    List<String> getIntegralSumStrGroupUserId();


}
