package cn.smarthse.modules.training.model;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 健康达人积分
 * </p>
 *
 * @author xubin
 * @since 2021-04-22
 */
@Data
public class HealthTalentPointsModel implements Serializable {

    private static final long serialVersionUID = 1L;


    private Long id;

    @ApiModelProperty(value = "企业ID")
    private Long cid;

    @ApiModelProperty(value = "人员Id")
    private Long staffId;

    @ApiModelProperty(value = "人员姓名")
    private String realName;
    private String userName;

    @ApiModelProperty(value = "积分")
    private Long points;

    @ApiModelProperty(value = "人员头像Id")
    private Long faceId;

    @ApiModelProperty(value = "当前用户排名")
    private Integer currentUserRankNum;



    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    @Transient
    private String idCard;

    @Transient
    private String workName;


}
