/**
 * 
 */
package cn.smarthse.modules.platform.provider;


import cn.smarthse.modules.platform.model.*;
import cn.smarthse.modules.platform.toC.model.UserThirdModel;
import cn.smarthse.modules.platform.toC.model.UserThirdTypeEnum;
import com.github.pagehelper.PageInfo;

import javax.smarthse.exception.ServiceException;
import java.util.List;

/**
 * 《平台用户接口》
 * 
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午3:30:20
 */
public interface IPUserService {

	/**
	 * 注册平台账号
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月4日-上午8:28:58
	 * @param model
	 * @return	平台用户Id
	 */
	Long registerUser(UserModel model);
	
	/**
	 * 第三方用户注册
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午3:52:06
	 * @param model			注册数据
	 * @param userThird			第三方数据包
	 * @return	Long			平台用户Id
	 */
	Long registeredByThird(UserModel model, UserThirdModel userThird);
	
	/**
	 * 根据Key查询用户基础信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午9:28:43
	 * @param key
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModelBase(String key) ;
	
	/**
	 * 根据身份证查询平台个人用户数据
	 * 
	 * @author liaoly
	 * @date 2020年11月19日 上午9:32:55
	 * @param idCard
	 * @return UserModel
	 */
	UserModel getUserModelBaseByIDcard(String idCard) ;
	
	/**
	 * 根据Key查询用户信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月11日-上午9:59:14
	 * @param key	用户名,手机,邮箱,openid,等第三方绑定表的token
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModel(String key);
	
	/**
	 * 根据Key查询用户信息
	 * <li> 2018/05/28 增加获取用户信息时,读取包含用户个人认证数据接口 edit by shao TO 健康顾问2.2
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月11日-上午9:59:14
	 * @param key	用户名,手机,邮箱,openid,等第三方绑定表的token
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModelWithUserCertification(String key);
	
	/**
	 * 处理用户绑定
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午4:20:20
	 * @param userThird
	 * @return	Integer		
	 */
	Integer processUserBindLogin(UserThirdModel userThird);
	
//	TODO　平台实名认证流程需变更
	/**
	 * 处理用户提交实名认证信息
	 * <li>平台已有提交信息时,ServiceException异常,C端自己处理
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午9:46:31
	 * @param certificationModel	认证信息
	 * @return	<li>0: 	未成功提交认证信息,可能平台有个人认证处理
	 * 			<li>1:	成功提交
	 * @throws ServiceException
	 */
	@Deprecated
	Integer processUserCertification(UserCertificationModel certificationModel) ;
	
	/**
	 * 根据平台Id查询平台认证信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午11:35:59
	 * @param userId
	 * @return	null:表示无认证信息(未认证)
	 */
	@Deprecated
	UserCertificationModel getUserCertificationModelByUserId(Long userId);
	
	
	/**
	 * 验证用户名与密码是否正确
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月6日-下午2:11:33
	 * @param username		用户名
	 * @param md5password	密码(md5)
	 * @return
	 */
	Boolean verifyPassword(String username, String md5password);
	
	/**
	 * 通过手机号码获取用户微信信息(基础)
	 * <li>基础信息仅包含openid,昵称,头像
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年8月13日-下午1:47:10
	 * @param mobile
	 * @return
	 */
	UserWeixinModel getUserWeixinModelByMobile(String mobile);
	
	/**
	 * 批量查询用户微信信息(基础)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年8月13日-下午1:48:31
	 * @param mobileList
	 * @return
	 */
	List<UserWeixinModel> getUserWeixinModelByMobile(List<String> mobileList);
	
	
	/**
	 * 根据userId/Token读取用户绑定信息
	 * <b>userId/Token	二选一
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-22-上午11:39:53
	 * @param userId		用户Id
	 * @param token			Token值
	 * @param bindLogin		绑定类型
	 * @return UserLoginBindModel
	 */
	UserLoginBindModel getUserLogin(Long userId, String token, UserThirdTypeEnum bindLogin);
	
	
	/**
	 * 读取 平台用户是否绑定了身份证,并返回绑定信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年8月20日-上午11:20:40
	 * @param userId		平台用户Id
	 * @return
	 */
	UserLoginBindModel getUserIDCard(Long userId);
	
	/**
	 * 读取 平台用户是否绑定了手机号,并返回绑定信息
	 * 
	 * @author liaoly
	 * @date 2021年8月24日 上午9:29:43
	 * @param userId : 平台用户账号id
	 * @return String 返回绑定的手机号，未绑定返回null
	 */
	String getUserMobile(Long userId);
	
	/**
	 * 绑定 平台用户+身份证
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年8月20日-上午11:20:40
	 * @param userId		平台用户Id
	 * @param IDCard		身份证
	 * @param fullname		真实姓名
	 * @return
	 */
	UserLoginBindModel bindUserIDCard(Long userId, String IDCard, String fullname);
	
	/**
	 * 查询平台账号列表(附带在线培训积分)(分页)
	 * @author liaoly
	 * @date 2020年11月18日 下午4:33:53
	 * @param page : 当前页码
	 * @param pageSize : 每页显示多少条数据(最大10)
	 * @param keyword : 模糊匹配关键字
	 * @param areaId : 区域限制条件(会查询出该区域以下的数据)
	 * @return PageInfo<UserInfoListModel>
	 */
	public PageInfo<UserInfoListModel> getUserInfoListModelList(Integer page, Integer pageSize, String keyword, Long areaId);
	
	/**
	 * 查询平台账号列表(附带在线培训积分)(分页)
	 * @author liaoly
	 * @date 2020年11月18日 下午4:33:53
	 * @param page : 当前页码
	 * @param pageSize : 每页显示多少条数据(最大10)
	 * @param keyword : 模糊匹配关键字
	 * @param areaId : 区域限制条件(会查询出该区域以下的数据)
	 * @param sidx : 自定义排序字段名
	 * @param sort : 排序方式(asc or desc)
	 * @return PageInfo<UserInfoListModel>
	 */
	public PageInfo<UserInfoListModel> getUserInfoListModelList(Integer page, Integer pageSize, String keyword, Long areaId, String sidx, String sort);
	
	/**
	 * 查询平台账号列表(附带在线培训积分)
	 * @author liaoly
	 * @date 2020年11月18日 下午4:33:53
	 * @param keyword : 模糊匹配关键字
	 * @param areaId : 区域限制条件(会查询出该区域以下的数据)
	 * @return List<UserInfoListModel>
	 */
	public List<UserInfoListModel> getUserInfoListModelList(String keyword, Long areaId);
	
	/**
	 * 查询平台账号列表(附带在线培训积分)
	 * @author liaoly
	 * @date 2020年11月18日 下午4:33:53
	 * @param cid : 企业id(为空则返回null)
	 * @return List<UserInfoListModel>
	 */
	public List<UserInfoListModel> getUserInfoListModelListByCid(Long cid);

    /**
     * 根据身份证查询平台个人用户数据
     *
     * @author liaoly
     * @date 2020年11月19日 上午9:32:55
     * @param idCard
     * @return UserModel
     */
    List<UserModel> getAllUserModelBaseIDcard() ;


	Boolean editPassword(Long userId,String password);

	Boolean disableOrAbleUser(Long userId,Boolean isForbidden);
	
}
