package cn.smarthse.modules.platform.model.pdf;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import cn.smarthse.modules.platform.enums.pdf.Orientation;
import cn.smarthse.modules.platform.enums.pdf.PrinterPageSize;
import lombok.Data;


/**
 * 
 * 《PDF 请求参数》
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年12月21日-下午2:11:22
 */
public @Data class PDFRequestParam implements Serializable{
	private static final long serialVersionUID = 7388080644872320579L;
	/**
	 * 默认文件
	 */
	private static final String DEFAULT_FILENAME = "result.pdf";
    /**
     * 默认布局
     */
    private static final Orientation DEFAULT_ORIENTATION = Orientation.PORTRAIT;
    /**
     * 默认打印纸为： A4
     */
    private static final PrinterPageSize DEFAULT_PAGESIZE = PrinterPageSize.A4;
    
    /**
     * 打印大小
     */
    private static final String DEFAULT_VIEWPORT = "800x600";
    
    /**
     * 转换目标 ：Url
     */
    private String target;
    /**
     * 输出文件名
     */
    private String filename;

    private Orientation orientation;
    
    private PrinterPageSize pageSize;

    private String viewport;
    
    public PDFRequestParam() {
        this.filename = DEFAULT_FILENAME;
        this.orientation = DEFAULT_ORIENTATION;
        this.pageSize = DEFAULT_PAGESIZE;
        this.viewport = DEFAULT_VIEWPORT;
    }

//    public void setFilename(String filename) {
//
//        this.filename = filename;
//
//        if (!StringUtils.hasText(filename)) {
//            this.filename = DEFAULT_FILENAME;
//        }
//
//        String extension = getFilenameExtension(this.filename);
//        if (!"pdf".equalsIgnoreCase(extension)) {
//            this.filename += ".pdf";
//        }
//    }


//    public void setOrientation(String orientation) {
//        this.orientation = Orientation.valueOf(upperCase(orientation));
//    }
//
//    public void setPageSize(String pageSize) {
//        PrinterPageSize.valueOf(upperCase(pageSize));
//    }
    
    
    /**
     * @see http://wkhtmltopdf.org/usage/wkhtmltopdf.txt
     * @return
     */
    public List<String> getCommandArguments() {
        List<String> arguments = new ArrayList<String>();
        
        arguments.add("--orientation");
        arguments.add(this.orientation.name());
        
        arguments.add("--page-size");
        arguments.add(this.pageSize.name());
        
        arguments.add("--viewport-size");
        arguments.add(this.viewport);
        
        arguments.add(this.target);
        
        return arguments;
    }
}
