/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 《平台用户绑定POJO》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年8月20日-上午11:13:43
 */
@Data
public class UserLoginBindModel implements Serializable {
	private static final long serialVersionUID = 8605053094662414529L;

	/**
     * ID
     */
    @ApiModelProperty(value="id")
    private Long id;

    /**
     * 用户id
     */
    @ApiModelProperty(value="用户id")
    private Long userId;

    /**
     * token,登录唯一信息(可能用户名,可能手机,可能邮箱....)
     */
    @ApiModelProperty(value="token")
    private String token;

    /**
     * 登录类型(1-手机,2-邮箱,3-微信,4-...)
     * @see cn.smarthse.modules.platform.toC.model.UserThirdTypeEnum
     */
    @ApiModelProperty(value="登录类型(1-手机,2-邮箱,3-微信,4-微信公众平台,5-个推,6-融云,7-身份证)")
    private Byte tokenType;
    
    /**
     * 第三方昵称(QQ/微信/支付宝/微博等三方平台需要)
     */
    @ApiModelProperty(value="第三方昵称")
    private String thirdNickname;

    /**
     * 第三方头像(QQ/微信/支付宝/微博等三方平台需要)
     */
    @ApiModelProperty(value="第三方头像")
    private String thirdFaceUrl;
	
}
