package cn.smarthse.modules.platform.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 平台提供给共享体系的平台账号列表model
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月18日 下午4:27:45
 */

public @Data class UserInfoListModel implements Serializable {
	
	private static final long serialVersionUID = -2108180089571409584L;
	
	/**
	 * 平台账号id
	 */
	private Long userId;
	
	/**
	 * 平台账号
	 */
	private String username;
	
	/**
	 * 真实姓名
	 */
	private String fullname;
	
	/**
	 * 手机号
	 */
	private String tel;
	
	/**
	 * 平台账号注册时间
	 */
	private Date regDate;
	
	/**
	 * 身份证
	 */
	private String idcard;
	
	/**
	 * 身份证审核状态，这里是(0-草稿,1-待审核,2-审核通过,3-审核不通过)
	 */
	private Integer reviewState;
	
	/**
	 * 身份证审核状态，这里是(0-草稿,1-待审核,2-审核通过,3-审核不通过)
	 */
	private String reviewStateStr;
	
	/**
	 * 在线培训积分
	 */
	private Integer integral;
	
	/**
	 * 所属企业
	 */
	private String companyName;
	
	/**
	 * 所属企业
	 */
	private String areaId;

	private Boolean isForbidden;
	
	public void setReviewState(Integer reviewState){
		
		this.reviewState = reviewState;
		if (reviewState != null) { //(0-草稿,1-待审核,2-审核通过,3-审核不通过)
			/*if (reviewState == 0) {
				this.reviewStateStr = "草稿";
			} else if (reviewState == 1) {
				this.reviewStateStr = "待审核";
			} else if (reviewState == 2) {
				this.reviewStateStr = "审核通过";
			} else if (reviewState == 3) {
				this.reviewStateStr = "审核不通过";
			} else {
				this.reviewStateStr = "未认证";
			}*/
			if (reviewState == 1) {
				this.reviewStateStr = "未认证";
			} else if (reviewState == 2) {
				this.reviewStateStr = "已认证";
			} 
		} else {
			this.reviewStateStr = "未认证";
		}
	}
}
