/**
 * 
 */
package cn.smarthse.modules.platform.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 共享体系 监管端 虚拟行政区划管理
 */
public @Data class SuperviseVirtualAreaModel implements Serializable{

	/**
     * ID
     */
	@ApiModelProperty(value="编号")
    private Long id;

    /**
     * 父编号
     */
    @ApiModelProperty(value="父编号")
    private String pid;

    /**
     * 老子级
     */
    private String oldCid;

    @ApiModelProperty(value="父编号")
    private Boolean expanded;
    @ApiModelProperty(value="父编号")
    private Boolean isLeaf;

    /**
     * 名称
     */
    @ApiModelProperty(value="名称")
    private String name;

    /**
     * 简拼
     */
    @ApiModelProperty(value="简拼")
    private String py;

    /**
     * 全拼
     */
    @ApiModelProperty(value="全拼")
    private String pyFull;


    /**
     * 级别(0-国家,1-省,2-市,3-区,4-乡,5-村)
     */
    @ApiModelProperty(value="级别(0-国家,1-省,2-市,3-区,4-乡,5-村,6-虚拟地区)")
    private Byte level;

    /**
     * 省编号
     */
    @ApiModelProperty(value="省编号")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty(value="省名称")
    private String provinceName;

    /**
     * 市编号
     */
    @ApiModelProperty(value="市编号")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty(value="市名称")
    private String cityName;

    /**
     * 区域ID
     */
    @ApiModelProperty(value="区域ID")
    private Long areaId;


    /**
     * 区域名称
     */
    @ApiModelProperty(value="区域名称")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @ApiModelProperty(value="乡镇街道编号")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @ApiModelProperty(value="乡镇街道名称")
    private String streetName;

    private Boolean isValid;

    @ApiModelProperty(value = "虚拟区域子级编号")
    private String virtualPid;

    @ApiModelProperty(value = "虚拟区域级别")
    private Byte virtualLevel;

    @ApiModelProperty(value = "虚拟区域子级")
    private List<SuperviseAreaModel> areaModels;

    /**
     * 更新时间
     */
    @ApiModelProperty(value="更新时间")
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateDate;
    
    @Transient
    public String getFullname() {
    	StringBuffer fullnames = new StringBuffer();
    	if(StringUtil.isNotEmpty(provinceName) && !"null".equalsIgnoreCase(provinceName)) {
    		fullnames.append(provinceName);
    	}
    	
    	if(StringUtil.isNotEmpty(cityName) && !"null".equalsIgnoreCase(cityName)) {
    		fullnames.append(cityName);
    	}
    	
    	if(StringUtil.isNotEmpty(areaName) && !"null".equalsIgnoreCase(areaName)) {
    		fullnames.append(areaName);
    	}
    	
    	if(StringUtil.isNotEmpty(streetName) && !"null".equalsIgnoreCase(streetName)) {
    		fullnames.append(streetName);
    	}
    	
    	return fullnames.toString();
    }


    @Transient
    public String getFullname(String separator) {
        StringBuffer result = new StringBuffer();
        //provinceName cityName areaName streetName
        //省
        if(StringUtils.hasText(this.getProvinceName())){
            result.append(this.getProvinceName()); //.append("/");
        }
        //市
        if(StringUtils.hasText(this.getCityName())){
            result.append(separator);
            result.append(this.getCityName()); //.append("/");
        }
        //区县
        if(StringUtils.hasText(this.getAreaName())){
            result.append(separator);
            result.append(this.getAreaName()); //.append("/");
        }
        //街道
        if(StringUtils.hasText(this.getStreetName())){
            result.append(separator);
            result.append(this.getStreetName()); //.append("/");
        }
        return result.toString();
    }

    public Boolean getExpanded() {
        if(level==0){
            return true;
        }
        return false;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
    }

    public Boolean getLeaf() {
        if(level==4){
            return true;
        }
        return false;
    }

    public void setLeaf(Boolean leaf) {
        isLeaf = leaf;
    }
}
