package cn.smarthse.modules.platform.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import javax.persistence.Column;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 《行政区域共享数据定义》
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2018年5月4日-上午8:57:20
 */
public @Data class AreaModel implements Serializable {
    private static final long serialVersionUID = 4601005338041387080L;

    /**
     * ID
     */
    @ApiModelProperty(value = "编号")
    private Long id;
    private AreaModel parentModel;
    /**
     * 父编号
     */
    @ApiModelProperty(value = "父编号")
    private Long parentId;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称")
    private String shortName;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 简拼
     */
    @ApiModelProperty(value = "简拼")
    private String py;

    /**
     * 全拼
     */
    @ApiModelProperty(value = "全拼")
    private String pyFull;

    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private String lng;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private String lat;

    /**
     * 级别(0-国家,1-省,2-市,3-区,4-乡,5-村)
     */
    @ApiModelProperty(value = "级别(0-国家,1-省,2-市,3-区,4-乡,5-村)")
    private Byte level;

    /**
     * 热度
     */
    @ApiModelProperty(value = "热度")
    private Integer orderBy;

    /**
     * 同一级的区域排序字段
     */
    @ApiModelProperty(value = "同一级的区域排序字段(默认为id值)")
    @Column(name = "sort")
    private Long sort;

    /**
     * 省编号
     */
    @ApiModelProperty(value = "省编号")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty(value = "省名称")
    private String provinceName;

    /**
     * 市编号
     */
    @ApiModelProperty(value = "市编号")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty(value = "市名称")
    private String cityName;

    /**
     * 区域ID
     */
    @ApiModelProperty(value = "区域ID")
    private Long areaId;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @ApiModelProperty(value = "乡镇街道编号")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @ApiModelProperty(value = "乡镇街道名称")
    private String streetName;


    @ApiModelProperty(value = "监督管辖区域下级是否是所有")
    private Boolean lowerIfAll;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    @Transient
    public String getFullname() {
        StringBuffer fullnames = new StringBuffer();
        if (StringUtil.isNotEmpty(provinceName) && !"null".equalsIgnoreCase(provinceName)) {
            fullnames.append(provinceName);
        }

        if (StringUtil.isNotEmpty(cityName) && !"null".equalsIgnoreCase(cityName)) {
            fullnames.append(cityName);
        }

        if (StringUtil.isNotEmpty(areaName) && !"null".equalsIgnoreCase(areaName)) {
            fullnames.append(areaName);
        }

        if (StringUtil.isNotEmpty(streetName) && !"null".equalsIgnoreCase(streetName)) {
            fullnames.append(streetName);
        }
        if (StringUtils.isEmpty(fullnames.toString()) && Objects.equals(this.areaId, 0L)) {
            return "全国";
        }
        return fullnames.toString();
    }

    @Transient
    public String getFullname(String separator) {
        StringBuffer result = new StringBuffer();
        //provinceName cityName areaName streetName
        //省
        if (StringUtils.hasText(this.getProvinceName())) {
            result.append(this.getProvinceName()); //.append("/");
        }
        //市
        if (StringUtils.hasText(this.getCityName())) {
            result.append(separator);
            result.append(this.getCityName()); //.append("/");
        }
        //区县
        if (StringUtils.hasText(this.getAreaName())) {
            result.append(separator);
            result.append(this.getAreaName()); //.append("/");
        }
        //街道
        if (StringUtils.hasText(this.getStreetName())) {
            result.append(separator);
            result.append(this.getStreetName()); //.append("/");
        }

        return result.toString();
    }

    @Transient
    public String getShortfullname() {
        StringBuffer fullnames = new StringBuffer();
        if (StringUtil.isNotEmpty(provinceName) && !"null".equalsIgnoreCase(provinceName)) {
            fullnames.append(provinceName.replace("省", ""));
        }

        if (StringUtil.isNotEmpty(cityName) && !"null".equalsIgnoreCase(cityName)) {
            fullnames.append(cityName.replace("市", ""));
        }

        if (StringUtil.isNotEmpty(areaName) && !"null".equalsIgnoreCase(areaName)) {
            fullnames.append(areaName.replace("区", "").replace("县", ""));
        }

        if (StringUtil.isNotEmpty(streetName) && !"null".equalsIgnoreCase(streetName)) {
            fullnames.append(streetName);
        }

        return fullnames.toString();
    }

    /**
     * 判断是否被选中
     */
    private Boolean isChecked = false;

    /**
     * 判断是否还有下级
     */
    private Boolean hasSon = true;

    List<AreaModel> children;
}
