package cn.smarthse.modules.platform.enums.agent;

import io.swagger.annotations.ApiModelProperty;

/**
 * 
 * @author cjy
 *
 */

public enum AgentBasicInfoEnum {
	agentType1("企业代理",(byte) 1),
	
	agentType2("个人代理",(byte) 2),
	
	agent_unique1("独家代理",(byte) 3),
	
	agent_unique2("非独家代理",(byte) 4);
	
	    // 成员变量
		@ApiModelProperty(value="代理类型名",notes="提示:企业代理，个人代理，独家代理或非独家代理")
		private String name;
		@ApiModelProperty(value="代理类型值",notes="提示:代理类型名对应的byte值")
		private Byte value;
		
		// 构造方法

		private AgentBasicInfoEnum(String name, Byte value) {
			this.name = name;
			this.value = value;
		}
		// 普通方法
		public static String getName(Byte value) {
			if (value == null) {
				return null;
			}
			for (AgentBasicInfoEnum c : AgentBasicInfoEnum.values()) {
				if (c.getValue().equals(value)) {
					return c.name;
				}
			}
			return null;
		}
						
						
		// get set 方法
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public Byte getValue() {
			return value;
		}
		public void setValue(Byte value) {
			this.value = value;
		}
}
