package cn.smarthse.modules.platform.enums;


/**
 * 运营后台/消息提醒/提醒类型（adminRemind.remindType）
 * @Description 
 * @Author liaoly
 * @Date 2020年2月12日 下午3:55:42
 */
public enum AdminRemindTypeEnum {

	/**
	 * 企业认证
	 */
	company_certification_1("待认证的企业", "有最新的待认证企业", 1),
	
	/**
	 * 个人实名认证
	 */
	personal_certification_2("待处理实名认证", "有最新的个人实名认证待处理", 2),
	/**
	 * 医生认证
	 */
	doctor_certification_3("待处理医生认证", "有最新的待认证医生", 3),
	/**
	 * 意见反馈
	 */
	opinion_feedback_4("意见反馈", "有最新的意见反馈", 4),
	/**
	 * 法规反馈
	 */
	legal_feedback_5("法规反馈", "有最新的法规反馈，请及时处理", 5),
	/**
	 * 平台新订单
	 */
	platform_order_6("平台新订单", "有最新的平台续费订单", 6),
	/**
	 * 健康顾问新订单
	 */
	healthAdvisor_order_7("健康顾问新订单", "有最新的健康顾问订单", 7),
	/**
	 * 申请试用
	 */
	try_soft_8("申请试用", "有最新的申请试用", 8),
	/**
	 * 试用到期
	 */
	try_soft_expired_9("试用到期", "xxx单位申请的xxx使用已到关闭时间，请及时处理", 9),
	;
	
	// 成员变量
	private Integer value;
	
	private String topic;
	
	private String conent;

	// 构造方法
	private AdminRemindTypeEnum(String topic, String conent, Integer value) {
		this.value = value;
		this.topic = topic;
		this.conent = conent;
	}
	
	// 普通方法
	public static String getTopic(Integer value) {
		if (value == null) {
			return null;
		}
		for (AdminRemindTypeEnum c : AdminRemindTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.topic;
			}
		}
		return null;
	}
	
	public static String getContent(Integer value) {
		if (value == null) {
			return null;
		}
		for (AdminRemindTypeEnum c : AdminRemindTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.conent;
			}
		}
		return null;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}
	
	public String getConent() {
		return conent;
	}

	public void setConent(String conent) {
		this.conent = conent;
	}
	
	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}
}
