package cn.smarthse.modules.kafka.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


 /**
 * 
 * 
 * 运营后台/消息提醒(kafka形式)
 * 
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @since 2019-10-12 11:12
 */
public @Data class AdminRemindModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 键值uuid_short
	 */
    @ApiModelProperty(value="键值uuid_short")
	private Long id;
	/**
	 * 业务id，来自各个系统
	 */
    @ApiModelProperty(value="业务id，来自各个系统")
	private Long businessId;
	/**
	 * 提醒类型，以枚举类AdminRemindTypeEnum为准
	 */
    @ApiModelProperty(value="提醒类型，以枚举类AdminRemindTypeEnum为准")
	private Integer remindType;
	/**
	 * 内容
	 */
    @ApiModelProperty(value="内容")
	private String content;
	/**
	 * 业务时间
	 */
    @ApiModelProperty(value="业务时间")
	private java.util.Date businessTime;
	/**
	 * 处理类型(1：未处理；2：已处理；3：已忽略)
	 */
    @ApiModelProperty(value="处理类型(1：未处理；2：已处理；3：已忽略)")
	private Integer dealType;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间")
	private java.util.Date createDate;
	/**
	 * 最后一次更新人id
	 */
    @ApiModelProperty(value="最后一次更新人id")
	private java.util.Date updateBy;
	/**
	 * 最后一次更新时间
	 */
    @ApiModelProperty(value="最后一次更新时间")
	private java.util.Date updateDate;
	/**
	 * 是否有效
	 */
    @ApiModelProperty(value="是否有效")
	private Boolean isValid;


}
