package cn.smarthse.modules.invoice.provider;

import cn.smarthse.modules.invoice.model.InvoiceKpParam;

/**
 * 在线发票公共服务接口
 *
 * @Author Wuxq [1071592960@qq.com]
 * @Date 2021年3月1日 上午11:20:21
 */
public interface IInvoiceProviderService {

    /**
     * 
     * @Description 开票请求接口
     * @Author Wuxq
     * @Date 13:49 2021/3/1
     * @Param [order]
     * @return java.lang.String  fpqqlsh:提交成功则返回发票请求流水号
     **/
    public String getInvoicingSerialNumber(InvoiceKpParam order);

    /**
     * @Description  开票结果查询接口
     * @Author Wuxq
     * @Date 15:57 2021/3/4
     * @Param [serialNumber] 开票请求流水号
     * @return java.lang.String
     **/
    public String queryInvoiceBySerialNumber(String[] serialNumber);

    /**
     * @Description  发票作废申请接口
     * @Author Wuxq
     * @Date 15:30 2021/3/4
     * @Param [serialNumber, invoiceCode, invoiceNumber]
     *          发票流水号      发票代码       发票号码 
     * @return java.lang.String 成功则返回发票请求流水号
     **/
    public String inValidInvoice(String serialNumber,String invoiceCode,String invoiceNumber);

}
