package cn.smarthse.modules.invoice.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description  发票请求明细
 * @Author Wuxq
 * @Date 10:18 2021/3/2
 **/
@Data
public class InvoiceKpDetailModel implements Serializable {
    
	private static final long serialVersionUID = -6466441046352340913L;

    @ApiModelProperty(value = "购方企业名称",required = true)
    private String buyername;

    @ApiModelProperty(value = "购方企业税号(企业要填，个人可为空)")
    private String taxnum;

    @ApiModelProperty(value = "购方企业地址(企业要填，个人可为空)")
    private String address;

    @ApiModelProperty(value = "购方企业银行开户行及账号(企业要填，个人可为空)")
    private String account;

    @ApiModelProperty(value = "购方企业电话")
    private String telephone;

    @ApiModelProperty(value = "订单号(每个企业唯一)",required = true)
    private String orderno;

    @ApiModelProperty(value = "单据时间")
    private String invoicedate;

    @ApiModelProperty(value = "销方企业银行开户行及账号",required = true)
    private String saletaxnum;

    @ApiModelProperty(value = "销方企业银行开户行及账号")
    private String saleaccount;

    @ApiModelProperty(value = "销方企业电话")
    private String salephone;

    @ApiModelProperty(value = "销方企业地址")
    private String saleaddress;

    @ApiModelProperty(value = "发票类型，1:正票;2：红票",required = true)
    private String kptype;

    @ApiModelProperty(value = "备注信息(冲红时，必须在备注中注明“对应正数发票代码:XXXXXXXXX号码:YYYYYYYY”文案，其中“X”为发票代码，“Y”为发票号码，否则接口会自动添加该文案)")
    private String message;

    @ApiModelProperty(value = "开票员",required = true)
    private String clerk;

    @ApiModelProperty(value = "收款人")
    private String payee;

    @ApiModelProperty(value = "复核人")
    private String checker;

    @ApiModelProperty(value = "对应蓝票发票代码(红票必填，不满12位请左补0)")
    private String fpdm;

    @ApiModelProperty(value = "对应蓝票发票号码(红票必填，不满8位请左补0)")
    private String fphm;

    @ApiModelProperty(value = "推送方式，-1:不推送;0:邮箱;1:手机(默认);2:邮箱&手机")
    private String tsfs = "1";

    @ApiModelProperty(value = "推送邮箱(tsfs为0或2时，此项为必填)")
    private String email;

    @ApiModelProperty(value = "推送手机(开票成功会短信提醒购方,不推送可不填，默认必填)",required = true)
    private String phone;

    @ApiModelProperty(value = "清单标志，0(默认):非清单,1:清单，根据项目名称数，自动生成清单;(卷票不支持清单)")
    private String qdbz = "0";

    @ApiModelProperty(value = "税局要求清单项目名称为（详见销货清单）(qdbz为1时，此项为必填)")
    private String qdxmmc;

    @ApiModelProperty(value = "代开标志，0(默认):非代开;1:代开。代开蓝票备注文案要求包含：“代开企业税号:***代开企业名称:***.”；代开红票备注文案要求：“对应正数发票代码:***号码:***代开企业税号:***代开企业名称:***.”。（代开企业税号与代开企业名称之间仅支持一个空格或无符号）")
    private String dkbz = "0";

    @ApiModelProperty(value = "部门门店id(诺诺网系统中的id)")
    private String deptid;

    @ApiModelProperty(value = "开票员id(诺诺网系统中的id)")
    private String clerkid;

    @ApiModelProperty(value = "发票种类，p(默认):电子增值税普通发票，c:增值税普通发票(纸票)，s:增值税专用发票，e:收购发票(电子)，f:收购发票(纸质)，r:增值税普通发票(卷式)，b:增值税电子专用发票;卷票r只支持13行明细")
    private String invoiceLine = "p";

    @ApiModelProperty(value = "成品油标志：0(默认)非成品油，1成品油")
    private String cpybz = "0";

    @ApiModelProperty(value = "红字信息表编号,专票冲红时，此项必填。且必须在备注中注明“开具红字增值税专用发票信息表编号ZZZZZZZZZZZZZZZZ”字样，其中“Z”为开具红字增值税专用发票所需要的长度为16位信息表编号。")
    private String billInfoNo;

    @ApiModelProperty(value = "发票明细",required = true)
    List<InvoiceGoodsDetailModel> detail;

}
