package cn.smarthse.modules.invoice.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description  发票商品明细
 * @Author Wuxq
 * @Date 10:18 2021/3/2
 **/
@Data
public class InvoiceGoodsDetailModel implements Serializable {
    
	private static final long serialVersionUID = -6466441046352340913L;

    @ApiModelProperty(value = "商品名称",notes = "如FPHXZ=1，则此商品行为折扣行，此版本折扣行不允许多行折扣，折扣行必须紧邻被折扣行，项目名称必须与被折扣行一致。",required = true)
    private String goodsname;

    @ApiModelProperty(value = "数量",notes ="数量，数量、单价必须都不填，或都必填，不可只填一个；当数量、单价都不填时，不含税金额、税额、含税金额都必填；" +
            "当数量、单价都填时，不含税金额、税额、含税金额可为空。开具成品油发票时必填。建议保留小数点后8位。冲红时项目数量为负数")
    private String num;

    @ApiModelProperty(value = "单价",notes ="同上，冲红时项目单价为正数")
    private String price;

    @ApiModelProperty(value = "单价含税标志，0:不含税,1:含税",required = true)
    private String hsbz;

    @ApiModelProperty(value = "税率",required = true)
    private String taxrate;

    @ApiModelProperty(value = "规格型号")
    private String spec;

    @ApiModelProperty(value = "单位，开具成品油发票时必填，必须为”升”或“吨”。")
    private String unit;

    @ApiModelProperty(value = "税收分类编码",notes = "签订免责协 议客户可不传入，由接口进行匹配，如对接口速度敏感、赋码准确要求高的企业，建议传入该字段",required = true)
    private String spbm;

    @ApiModelProperty(value = "自行编码")
    private String zxbm;

    @ApiModelProperty(value = "发票行性质，0:正常行;1:折扣行;2:被折扣行",required = true)
    private String fphxz;

    @ApiModelProperty(value = "优惠政策标识,0:不使用;1:使用")
    private String yhzcbs;

    @ApiModelProperty(value = "增值税特殊管理，如：即征即退、免税、简易征收等",notes = "当yhzcbs为1时，此项必填")
    private String zzstsgl;

    @ApiModelProperty(value = "零税率标识，空:非零税率;1:免税;2:不征税;3:普通零税率",
            notes = "普通零税率<YHZCBS>0</YHZCBS>\n" +
            "<LSLBS>3</LSLBS>\n" +
            "<ZZSTSGL></ZZSTSGL>\n" +
            "\n" +
            "免税<YHZCBS>1</YHZCBS>\n" +
            "<LSLBS>1</LSLBS>\n" +
            "<ZZSTSGL>免税</ZZSTSGL>\n" +
            "\n" +
            "不征税<YHZCBS>1</YHZCBS>\n" +
            "<LSLBS>2</LSLBS>\n" +
            "<ZZSTSGL>不征税</ZZSTSGL>")
    private String lslbs;

    @ApiModelProperty(value = "扣除额",notes = "小数点后两位。差额征收的发票目前只支持一行明细。不含税差额 = 不含税金额 - 扣除额； 税额 = 不含税差额*税率\n" +
            "注意：传0、空或字段不传，都表示非差额征税；传0.00才表示差额征税:0.00")
    private String kce;

    @ApiModelProperty(value = "不含税金额",notes = "精确到小数点后面两位，红票为负。不含税金额、税额、含税金额任何一个不传时，会根据传入的单价，数量进行计算，可能和实际数值存在误差，建议都传入")
    private String taxfreeamt;

    @ApiModelProperty(value = "税额",notes = "同上")
    private String tax;

    @ApiModelProperty(value = "含税金额",notes = "同上，在确认含税单价或者含税金额的情况下，含税标志为1含税，税额=round((数量*含税单价)*税率/(1+税率)),2)，不含税金额=含税金额-税额。\n" +
            "在确认不含税单价或者不含税金额的情况下，含税标志为0不含税，税额=round((数量*不含税单价)*税率),2)，含税金额=不含税金额+税额。")
    private String taxamt;

}
