/**
 * 
 */
package cn.smarthse.modules.hospitaldevice.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 《2.4.1.	体检信息模型(HealthCheckModel)》
 * <ps>摘至:如果此次体检该人员属于复检人员（PS系统中此次体检该人员自动生成了一条复检记录）则显示此按钮/文本，否则不显示。如果复检记录未完成，显示文本“请及时前往医院复查”，如果复检记录已完成，则显示按钮“查看复查结果”
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-12-21-上午10:26:30
 */
public @Data class HealthCheckModel implements Serializable {
	private static final long serialVersionUID = 5200714721123261432L;
	/**
	 * 开始年月日,格式(YYYY-MM-DD)
	 */
	private Date startDate;
	
	/**
	 * 结束年月日,格式(YYYY-MM-DD)
	 * NULL视为至今
	 */
	private Date endDate;
	
	/**
	 * 检查类型
	 * <li>1-	上岗前职业健康检查
	 * <li>2-	在岗期间职业健康检查
	 * <li>3-	复查
	 * <li>4-	离岗时职业健康检查
	 * <li>5-	应急照射或事故照射的健康检查
	 * 
	 * @see 2.2.1.	体检类型枚举类(HealthCheckTypeEnum)
	 */
	private transient byte checkType;
	
	/**
	 * 体检结果
	 * 0-未见异常 1-其他疾病或异常 2-复查 3-职业禁忌证  4-疑似职业病
	 */
	private Byte checkresult;
	
	/**
	 * 适应性意见
	 */
	private String adaptive;
	
	/**
	 * 员工体检Id(业务中)
	 */
	private Integer staffCheckId;
	
	/**
	 * 复查诊断时间,格式(YYYY-MM-DD)
	 */
	private Date reviewDate;
	
	/**
	 * 复查诊断结论
	 */
	private String reviewConclusion;
	
	/**
	 * 人员处理情况
	 */
	private String reviewHandle;
	
	/**
	 * 是否已经处理
	 * 0-未处理 1-已处理
	 */
	private Byte isprocessed;
	
	/**
	 * 开始时间
	 */
	private String start = "";
	
	/**
	 * 结束时间
	 */
	private String end = "";
	
	/**
	 * 复查时间
	 */
	private String review = "";

}
