package cn.smarthse.modules.healthadvisor.vo;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 个人用户列表查询参数对象
 * @Description 
 * @Author liaoly
 * @Date 2019年12月20日 下午1:39:50
 */
@Api(value="个人用户列表查询参数对象")
public @Data class UserQueryParam implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value="id")
	private Long id;
	
	@ApiModelProperty(value="平台账号id")
	private Long userId;
	
	@ApiModelProperty(value="输入框通用查询字段(eg: 手机号, 账号, 姓名。。。)")
	private String name;
	
	@ApiModelProperty(value="时间匹配 开始时间")
	private Date beginTime;
	
	@ApiModelProperty(value="时间匹配 结束时间")
	private Date endTime;
	
	@ApiModelProperty(value="是否是内部人员账号(1: 是；0：不是)")
	private Boolean isInternal;
	
	@ApiModelProperty(value="用户认证状态(0-未认证，1-待认证，2-已认证，3-认证不通过）")
	private Byte userCheckState;
	
	@ApiModelProperty(value="账号是否禁用(true: 启用状态  false: 禁用状态)")
	private Boolean isValid;
}
