package cn.smarthse.modules.healthadvisor.vo;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 健康顾问查询参数对象
 * @Description 
 * @Author liaoly
 * @Date 2020年1月7日 上午9:06:38
 */
@Api(value="健康顾问查询参数对象")
public @Data class OrderQueryParam implements Serializable {
	
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value="订单id")
	private Long orderId;
	
	@ApiModelProperty(value="模糊查询关键字(微信号/订单号/申请人/服务医生)")
	private String keyword;
	
	@ApiModelProperty(value="订单类型(1-电话,2-在线)")
	private Byte orderType;
	
	@ApiModelProperty(value="订单状态(0-待支付，1-待服务，2-进行中，3-医生已完成，4-关闭已退款 5-关闭未退款 6-用户已完成)")
	private Byte orderStatus;
	
	@ApiModelProperty(value="时间匹配 开始时间")
	private Date beginTime;
	
	@ApiModelProperty(value="时间匹配 结束时间")
	private Date endTime;
}
