package cn.smarthse.modules.healthadvisor.model;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 健康顾问账号列表model
 * @Description 
 * @Author liaoly
 * @Date 2020年2月11日 下午1:28:13
 */
public @Data class HaUserModel implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value="用户账号id")
    private Long id;
	
	@ApiModelProperty(value="平台用户账号id")
    private Long userId;
	
	@ApiModelProperty(value="企业id")
    private Long cid;
	
	@ApiModelProperty(value="姓名")
	private String name;
	
	@ApiModelProperty(value="注册来源")
	private String regSource;
	
	@ApiModelProperty(value="健康顾问账号")
    private String username;
	
	@ApiModelProperty(value="手机号码")
	private String mobile;
	
	@ApiModelProperty(value="身份证号")
	private String cardNo;
	
	@ApiModelProperty(value="健康顾问用户认证状态(0-未认证，1-待认证，2-已认证，3-认证不通过)")
	private Byte userCheckState;
	
	@ApiModelProperty(value="健康顾问用户认证状态(0-未认证，1-待认证，2-已认证，3-认证不通过)")
	private String userCheckStateStr;
	
	@ApiModelProperty(value="医生职称")
	private String jobTitle;
	
	@ApiModelProperty(value="医生所在医院/执业医院")
	private String hospitalName;
    
	@ApiModelProperty(value="是否医生(1: 是；0：不是)")
    private Integer isDoctor;
	
    @ApiModelProperty(value="是否是内部人员账号(1: 是；0：不是)")
    private Integer isInternal;
	
	@ApiModelProperty(value="内部人员标签")
	private String isInternalStr;
	
	@ApiModelProperty(value="头像文件编号")
    private Long faceId;
	
	@ApiModelProperty(value="手持身份证正面照片")
	private Long cardPositiveFileId;
	
	@ApiModelProperty(value="身份证背面照片")
	private Long cardBackFileId;
	
	@ApiModelProperty(value="备注")
	private String remark;
	
	@ApiModelProperty(value="创建时间")
	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
    private Date createDate;
	
	@ApiModelProperty(value="禁用状态(true：启用状态；false：禁用状态)")
    private Boolean isValid;
	
	public void setIsInternal(Integer isInternal) {
		
		if (isInternal == null) return;
		
		this.isInternal = isInternal;//是否是内部人员标签
		
		if (isInternal == 1) {
			this.isInternalStr = "内部人员";
		} else {
			this.isInternalStr = "不是内部人员";
		}
	}
	
	public void setUserCheckState(Byte userCheckState) {
		
		if (userCheckState == null) return;
		
		this.userCheckState = userCheckState;//健康顾问用户认证状态(0-未认证，1-待认证，2-已认证，3-认证不通过)
		//HaDoctorInfoCheckStateEnum
		if (userCheckState == 0) {
			this.userCheckStateStr = "未认证";
		} else if (userCheckState == 1){
			this.userCheckStateStr = "待认证";
		} else if (userCheckState == 2){
			this.userCheckStateStr = "已认证";
		} else if (userCheckState == 3){
			this.userCheckStateStr = "认证不通过";
		}
	}
}
