package cn.smarthse.modules.health.enums.home.grade;


import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: GradeSource
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 19
 * @since 2023/6/26-18:19
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum GradeSourceEnum {
    //0无来源， 1接害三人以下企业 2 分类自查 3 根据行业划分  4 依据容错自纠调整
    NOSOURCE("未分类",0),
    LESS3("接害三人以下企业",1),
    BYREPORT ("分类自查",2),
    BYINDU("根据行业划分",3),
    BYADJUST("依据容错自纠调整",4),
    SUPENDREFORM("风险未及时化解",5),
    CREDITSUPERVISE("信用监管",6),
    COMPLIANCE("合规达标提档企业",7),
    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private GradeSourceEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }


    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (GradeSourceEnum c : GradeSourceEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }// 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (GradeSourceEnum c : GradeSourceEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }


    public static String getNoGradeSource(String gradeSource) {
        if (StrUtil.isNotBlank(gradeSource)) {
            List<String> gradeSourceArr = StrUtil.split(gradeSource, ",");
            Set<String> gradeSourceSet = new HashSet<>(gradeSourceArr);
            Set<String> resultSet = new HashSet<>();
            for (GradeSourceEnum value : GradeSourceEnum.values()) {
                if (!gradeSourceSet.contains(value.getCode())) {
                    resultSet.add(value.getCode()+"");
                }
            }
            return StrUtil.join(",",resultSet);
        }
        return null;
    }
}
