package cn.smarthse.modules.eduTraining.provider;

import java.util.List;

import cn.smarthse.modules.eduTraining.model.*;
import cn.smarthse.modules.eduTraining.model.detail.EduTrainingDetailModel;
import cn.smarthse.modules.eduTraining.model.video.SummaryVideoMemberModel;
import cn.smarthse.modules.eduTraining.model.video.VideoMemberModel;

/**
 * 提供给手机端的精准培训服务接口
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月27日 上午11:20:21
 */
public interface IEduTrainingUserExamProviderService {
	
	/**
	 * 查询培训考试人的 培训课程学习 概要信息(app端-培训课程-培训课程学习-概要信息)
	 * @author liaoly
	 * @date 2021年1月29日 上午11:24:06
	 * @param memberId : 培训人id(TrainingMember.id)
	 * @return SummaryVideoMemberModel
	 */
	public SummaryVideoMemberModel getSummaryVideoMemberModel(Long memberId);
	
	/**
	 * 查询培训考试人的 培训课程列表(app端-培训课程-培训课程学习-培训课程列表)
	 * @author liaoly
	 * @date 2021年1月29日 上午11:24:06
	 * @param memberId : 培训人id(TrainingMember.id)
	 * @return List<VideoMemberModel>
	 */
	public List<VideoMemberModel> getVideoMemberModelList(Long memberId);
	
	/**
	 * 更新培训人指定的培训课程的学习时长(用于下次打开视频课程时自动跳转到上传观看位置)
	 * @author liaoly
	 * @date 2021年1月29日 上午11:24:06
	 * @param videoMemberId : training_video_member.id
	 * @param learnTime : 视频学习时长(training_video_member.learnTime)
	 */
	public void updateLearnTime(Long videoMemberId, Long learnTime);
	
	/**
	 * @Description  线下考试报名模块-查询考试列表
	 * @Author Wuxq
	 * @Date 9:26 2021/2/1
	 * @Param [memberId]
	 * @return cn.smarthse.modules.eduTraining.model.EduTrainingUserExamTimeModel
	 **/
	public List<EduTrainingUserExamTimeModel> getExamList(Long memberId);
	
	/**
	 * @Description  线下考试报名模块-报名
	 * @Author Wuxq
	 * @Date 9:25 2021/2/1
	 * @Param [memberId, examTimeId]
	 * @return 0:数据错误，报名失败   1:已报满  2:报名成功
	 **/
	public Integer signUp(Long memberId, Long examTimeId);
	
	/**
	 * 个人中心模块-个人培训记录列表
	 * 
	 * @author liaoly
	 * @date 2021年1月27日 上午11:21:09
	 * @param staffId : 用户id(training_member.staffId)
	 * @return EduTrainingUserExamModel 培训记录列表
	 */
	public List<EduTrainingMemberModel> getTrainingMemberLogList(String IdCard ,Long cid);
	
	/**
	 * @Description  个人中心模块-个人考核记录列表(exam_type:1、预考核 2、正式考试)
	 * @Author Wuxq
	 * @Date 9:45 2021/1/29
	 * @Param [memberId, examType]
	 * @return java.util.List<cn.smarthse.modules.eduTraining.model.EduTrainingUserExamLogModel>
	 **/
	public List<EduTrainingUserExamLogModel> getTrainingUserExamLogList(Long memberId, Integer examType);

	/**
	 * @Description  个人中心模块-课程信息学习情况列表
	 * @Author Wuxq
	 * @Date 13:06 2021/1/29
	 * @Param [memberId]
	 * @return java.util.List<cn.smarthse.modules.eduTraining.model.EduTrainingVideoMemberModel>
	 **/
	public List<EduTrainingVideoMemberModel> getTrainingUserVideoList(Long memberId);
	
	/**
	 * @Description  个人中心模块-课程信息学习情况详情
	 * @Author Wuxq
	 * @Date 13:07 2021/1/29
	 * @Param [TrainingVideoMember.Id]
	 * @return cn.smarthse.modules.eduTraining.model.EduTrainingVideoMemberDetailModel
	 **/
	public EduTrainingVideoMemberDetailModel getTrainingVideoMemberDetailModel(Long id);

	/**
	 * 考试考题解析详情
	 *
	 * @author yangzp
	 * @date 2021年2月2日 上午10:02:25
	 * @param questionId : 试题id(training_question.id)
	 * @return EduTrainingExamQuestionModel 试题详情
	 */
	public EduTrainingExamQuestionModel getTrainingExamQuestionAnswerDetail(Long questionId);

	/**
	 * 查询用户考试结果
	 * @author haosw
	 * @date 2021/2/2 13:16
 	 * @param examId: 试卷id
	 * @return
	*/
	public EduTrainingUserExamResultModel getUserExamResult(Long examId);

	/**
	 * @Description  查询指定用户的培训考试试题列表
	 * @Author Wuxq
	 * @Date 16:14 2021/2/2
	 * @Param [memberId]
	 * @return java.util.List<QuestionModel>
	 **/
	public List<EduTrainingQuestionModel> getTrainingQuestionModelList(Long memberId);


	/**
	 * 根据身份证 和 企业id 查询当年的trainingMember.id
	 * @author liaoly
	 * @date 2021年2月2日 下午4:24:48
	 * @param idCard : 身份证
	 * @param cid : 企业id
	 * @return Long TrainingMember.id
	 */
	public Long getMemberIdByIdcardAndCid(String idCard, Long cid);

    /**
     * 批量保存答题记录
     * @author xubin
     * @date 2021年2月2日 下午4:24:48
     * @param param.ExamLogRecordModel与TrainingExamLog相同
     * @param param.ExamLogRecordDetailModel与TrainingExamLogDetail相同
     * @return TrainingExamResultModel TrainingExamResultVo相同
     */
	public TrainingExamResultModel saveExamLogRecordModel(EduTrainingLogRecordParam param);

	/**
	 * 根据trainingExamLogId查询用户的一条正式考试的所有试题答题详情列表
	 * @author yangzp
	 * @date 2021年2月3日 下午16:24:15
	 * @param trainingExamLogId : TrainingExamLog.id
	 * @return List<EduTrainingQuestionModel>
	 */
	public List<EduTrainingQuestionModel> getExamLogDetailModelList(Long trainingExamLogId);

	/**
	 * @Description  预考核 / 在线考试  答题开始页 考试信息介绍
	 * @Author Wuxq
	 * @Date 13:22 2021/2/5
	 * @Param [memberId]
	 * @return cn.smarthse.modules.eduTraining.model.EduTrainingUserExamRuleModel
	 **/
	public EduTrainingUserExamRuleModel getEduTrainingUserExamRuleModel(Long memberId);

	/**
	 * @Description  预考核 / 在线考试 开始答题 初始化数据
	 * @Author Wuxq
	 * @Date 13:22 2021/2/5
	 * @Param [memberId]
	 * @return cn.smarthse.modules.eduTraining.model.EduTrainingUserExamStartParamsModel
	 **/
	public EduTrainingUserExamStartParamsModel eduTrainingUserExamStartInit(Long memberId);


	/**
	 * 查询指定memberId的角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）(TrainingMember.role)
	 * @author liaoly
	 * @date 2021年2月19日 下午3:49:16
	 * @param memberId : TrainingMember.id
	 * @return Byte 返回TrainingMember.role
	 */
	public Byte getRoleByMemberId(Long memberId);

	/**
	 * 查询培训考试人的精准培训详情(环节信息)
	 * @author liaoly
	 * @date 2021年2月20日 上午8:42:09
	 * @param memberId 
	 * @return String
	 */
	public EduTrainingDetailModel getEduTrainingDetailModel(Long memberId);

}
