package cn.smarthse.modules.eduTraining.model.video;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 培训课程学习-视频学习model
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月4日 上午8:22:30
 */
@ApiModel(value = "培训课程学习-概要信息model", description = "培训课程学习-概要信息model")
public @Data class VideoMemberModel implements Serializable {

    private static final long serialVersionUID = 5265521818370949522L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "用户id")
    private Long memberId;

    @ApiModelProperty(value = "视频课程名称")
    private String videoName;

    @ApiModelProperty(value = "视频课程url")
    private String videoFileUrl;

    @ApiModelProperty(value = "视频课程缩略图url")
    private String videoImageUrl;

    @ApiModelProperty(value = "视频简介")
    private String videoDescription;

    @ApiModelProperty(value = "视频学习状态")
    private String status;

    @ApiModelProperty(value = "视频时长/s")
    private Long videoTime;

    @ApiModelProperty(value = "视频时长(格式化了)")
    private String videoTimeStr;

    @ApiModelProperty(value = "对应学时")
    private BigDecimal learnHour;

    @ApiModelProperty(value = "已学习时长(单位为秒)")
    private Integer learnTime;

    public void setVideoTime(Long videoTime) {
        this.videoTime = videoTime; //单位为秒

        if (videoTime == null) return;

        //转视频时长格式
        long minutes = videoTime / 60;
        long seconds = videoTime % 60;

        this.setVideoTimeStr((minutes < 10 ? ("0" + minutes) : minutes) + ":" + (seconds < 10 ? ("0" + seconds) : seconds));
    }
}

