package cn.smarthse.modules.eduTraining.model.video;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 视频学习概要信息model
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月4日 上午8:22:30
 */
@ApiModel(value="培训课程学习-概要信息model", description="培训课程学习-概要信息model")
public @Data class SummaryVideoMemberModel implements Serializable {
	
	private static final long serialVersionUID = -555727483452100740L;

	@ApiModelProperty(value = "培训年度")
	private Integer trainingYear;
	
	@ApiModelProperty(value = "培训人员角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）")
	private Byte role;
	
	@ApiModelProperty(value = "培训类别（0-初训 1-复训）")
	private Byte trainingType;
	
	@ApiModelProperty(value = "要求培训学时/h")
	private BigDecimal requireHour;
	
	@ApiModelProperty(value = "已培训学时/h")
	private BigDecimal trainedHour;
}

