package cn.smarthse.modules.eduTraining.model.detail;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 精准培训-精准培训详情model(环节信息)
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月20日 上午9:45:59
 */
public @Data class EduTrainingDetailModel implements Serializable {

	private static final long serialVersionUID = 5834990029744296252L;
	
	@ApiModelProperty(value = "角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）")
	private Byte role;
	
	@ApiModelProperty(value = "当前培训环节(1-培训课程学习; 2-在线预考核(管理者或者负责人)/在线考试(劳动者); 3-线下考试报名; 4-线下考试)")
	private Integer segment;
	
	/**
	 *1-1：表示劳动者，且没有培训课程没有完成的<br>
	 *1-2：表示劳动者，培训课程已完成，在线考试<br>
	 *1-3：表示劳动者，在线考试已通过，考试成绩<br>
	 *1-4：表示劳动者，在线考试未通过，在线考试，考试记录<br>
	 *2-1：表示管理者或者负责人，且没有培训课程没有完成的<br>
	 *2-2：表示管理者或者负责人，培训课程已完成，在线预考核<br>
	 *2-3：表示管理者或者负责人，在线预考核通过，线下报名考试<br>
	 *2-4：表示管理者或者负责人，在线预考核未通过，在线预考核，预考核记录<br>
	 *2-5：表示管理者或者负责人，线下考试已通过，考试成绩<br>
	 *2-6：表示管理者或者负责人，线下考试未通过，线下考试报名，考试记录<br>
	 *2-7：表示管理者或者负责人，已报名线下考试，报名考试地点信息内容
	 */
	@ApiModelProperty(value = "当前培训环节编码")
	private String segmentCode;
	
	@ApiModelProperty(value = "第1个环节数据model(培训课程学习)")
	private String segmentModel1;
	
	@ApiModelProperty(value = "第2个环节数据(在线预考核(管理者或者负责人)/在线考试(劳动者))")
	private String segmentModel2;
	
	@ApiModelProperty(value = "第3个环节数据(线下考试报名)")
	private String segmentModel3;
	
	@ApiModelProperty(value = "第4个环节数据(线下考试)")
	private String segmentModel4;
	
	@ApiModelProperty(value = "第1个环节数据model(培训课程学习)")
	private EduTrainingSegmentModel1 eduTrainingSegmentModel1;
}
