package cn.smarthse.modules.eduTraining.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;

/**
 * @author haosw
 * @Description 考试结束页
 * @date 2021/2/2
 */
@Data
@ApiModel(value="TrainingExamEndVo对象", description="考试结束页")
public class TrainingExamResultModel implements Serializable {
	
	private static final long serialVersionUID = -6441742734740140449L;

	@ApiModelProperty(value = "考试得分")
    private Integer score;

    @ApiModelProperty(value = "考试结果(1:合格，2:不合格）")
    private Integer isEligible;

    @ApiModelProperty(value = "考试用时")
    private String examTime;

    @ApiModelProperty(value = "开始答题时间")
    private LocalDateTime beginTime;

    @ApiModelProperty(value = "结束答题时间")
    private LocalDateTime endTime;

    public String getExamTime() {
        if(beginTime == null || endTime == null) return null;
        Duration duration = Duration.between(beginTime,endTime);
        examTime = formatString(duration.toHours())+":"+formatString(duration.toMinutes()%60)+":"+formatString((duration.toMillis()/1000)%60);
        return examTime;
    }
    private String formatString(Long s){
        String result = String.valueOf(s);
        if(result.length()<2){
            result = "0"+result;
        }
        return result;
    }

}
